/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.cli;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.utils.KeycloakModelUtils;

class BatchTaskRunner {
    BatchTaskRunner() {
    }

    static void runInBatches(int first, int count, int batchCount, KeycloakSessionFactory sessionFactory, final BatchTask batchTask) {
        final StateHolder state = new StateHolder();
        state.firstInThisBatch = first;
        state.remaining = count;
        state.countInThisBatch = Math.min(batchCount, state.remaining);
        while (state.remaining > 0) {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    batchTask.run(session, state.firstInThisBatch, state.countInThisBatch);
                }
            });
            state.firstInThisBatch += state.countInThisBatch;
            state.remaining -= state.countInThisBatch;
            state.countInThisBatch = Math.min(batchCount, state.remaining);
        }
    }

    @FunctionalInterface
    public static interface BatchTask {
        public void run(KeycloakSession var1, int var2, int var3);
    }

    private static class StateHolder {
        int firstInThisBatch;
        int countInThisBatch;
        int remaining;

        private StateHolder() {
        }
    }
}

