/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.cli;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.testsuite.util.cli.AbstractCommand;
import org.keycloak.testsuite.util.cli.BatchTaskRunner;

public abstract class AbstractSessionCacheCommand
extends AbstractCommand {
    private static final Set<String> SUPPORTED_CACHE_NAMES = new TreeSet<String>(Arrays.asList("sessions", "offlineSessions", "clientSessions", "offlineClientSessions"));

    @Override
    protected void doRunCommand(KeycloakSession session) {
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        String cacheName = this.getArg(0);
        if (!SUPPORTED_CACHE_NAMES.contains(cacheName)) {
            this.log.errorf("Invalid cache name: '%s', Only cache names '%s' are supported", (Object)cacheName, SUPPORTED_CACHE_NAMES);
            throw new AbstractCommand.HandledException();
        }
        Cache ispnCache = provider.getCache(cacheName);
        this.doRunCacheCommand(session, (Cache<String, SessionEntityWrapper>)ispnCache);
        ispnCache.entrySet().stream().skip(0L).limit(10L).collect(Collectors.toMap(new Function(){

            public Object apply(Object entry) {
                return ((Map.Entry)entry).getKey();
            }
        }, new Function(){

            public Object apply(Object entry) {
                return ((Map.Entry)entry).getValue();
            }
        }));
    }

    protected void printSession(String id, UserSessionEntity userSession) {
        if (userSession == null) {
            this.log.info((Object)("Not found session with Id: " + id));
        } else {
            this.log.info((Object)("Found session. ID: " + this.toString(userSession)));
        }
    }

    protected String toString(UserSessionEntity userSession) {
        int clientSessionsSize = userSession.getAuthenticatedClientSessions() == null ? 0 : userSession.getAuthenticatedClientSessions().size();
        return "ID: " + userSession.getId() + ", realm: " + userSession.getRealmId() + ", lastAccessTime: " + Time.toDate((int)userSession.getLastSessionRefresh()) + ", authenticatedClientSessions: " + clientSessionsSize;
    }

    @Override
    public String printUsage() {
        return this.getName() + " <cache-name>";
    }

    protected abstract void doRunCacheCommand(KeycloakSession var1, Cache<String, SessionEntityWrapper> var2);

    public static class CreateManySessionsProviderCommand
    extends AbstractSessionCacheCommand {
        @Override
        public String getName() {
            return "createManySessionsProvider";
        }

        @Override
        protected void doRunCacheCommand(KeycloakSession session, Cache<String, SessionEntityWrapper> cache) {
            String realmName = this.getArg(1);
            String clientId = this.getArg(2);
            String username = this.getArg(3);
            int count = this.getIntArg(4);
            int batchCount = this.getIntArg(5);
            BatchTaskRunner.runInBatches(0, count, batchCount, session.getKeycloakSessionFactory(), (batchSession, firstInIteration, countInIteration) -> {
                RealmModel realm = batchSession.realms().getRealmByName(realmName);
                ClientModel client = realm.getClientByClientId(clientId);
                UserModel user = batchSession.users().getUserByUsername(realm, username);
                for (int i = 0; i < countInIteration; ++i) {
                    UserSessionModel userSession = session.sessions().createUserSession(realm, user, username, "127.0.0.1", "form", false, null, null);
                    session.sessions().createClientSession(userSession.getRealm(), client, userSession);
                }
                this.log.infof("Created '%d' sessions started from offset '%d'", (Object)countInIteration, (Object)firstInIteration);
            });
            this.log.infof("Created all '%d' sessions", (Object)count);
        }

        @Override
        public String printUsage() {
            return this.getName() + " <cache-name> <realm-name> <client-id> <user-name> <count> <count-in-batch>";
        }
    }

    public static class CreateManySessionsCommand
    extends AbstractSessionCacheCommand {
        @Override
        public String getName() {
            return "createManySessions";
        }

        @Override
        protected void doRunCacheCommand(KeycloakSession session, Cache<String, SessionEntityWrapper> cache) {
            String realmName = this.getArg(1);
            int count = this.getIntArg(2);
            int batchCount = this.getIntArg(3);
            BatchTaskRunner.runInBatches(0, count, batchCount, session.getKeycloakSessionFactory(), (batchSession, firstInIteration, countInIteration) -> {
                for (int i = 0; i < countInIteration; ++i) {
                    UserSessionEntity userSession = new UserSessionEntity();
                    String id = KeycloakModelUtils.generateId();
                    userSession.setId(id);
                    userSession.setRealmId(realmName);
                    userSession.setLastSessionRefresh(Time.currentTime());
                    cache.put((Object)id, (Object)new SessionEntityWrapper((SessionEntity)userSession));
                }
                this.log.infof("Created '%d' sessions started from offset '%d'", (Object)countInIteration, (Object)firstInIteration);
            });
            this.log.infof("Created all '%d' sessions", (Object)count);
        }

        @Override
        public String printUsage() {
            return this.getName() + " <cache-name> <realm-name> <count> <count-in-batch>";
        }
    }

    public static class SizeLocalCommand
    extends AbstractSessionCacheCommand {
        @Override
        public String getName() {
            return "sizeLocal";
        }

        @Override
        protected void doRunCacheCommand(KeycloakSession session, Cache<String, SessionEntityWrapper> cache) {
            this.log.info((Object)("Size local: " + cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).size()));
        }
    }

    public static class GetLocalCommand
    extends AbstractSessionCacheCommand {
        @Override
        public String getName() {
            return "getLocal";
        }

        @Override
        protected void doRunCacheCommand(KeycloakSession session, Cache<String, SessionEntityWrapper> cache) {
            String id = this.getArg(1);
            cache = ((AdvancedCache)cache).withFlags(Flag.CACHE_MODE_LOCAL);
            UserSessionEntity userSession = (UserSessionEntity)((SessionEntityWrapper)cache.get((Object)id)).getEntity();
            this.printSession(id, userSession);
        }

        @Override
        public String printUsage() {
            return this.getName() + " <cache-name> <user-session-id>";
        }
    }

    public static class ListCommand
    extends AbstractSessionCacheCommand {
        @Override
        public String getName() {
            return "list";
        }

        @Override
        protected void doRunCacheCommand(KeycloakSession session, Cache<String, SessionEntityWrapper> cache) {
            for (String id : cache.keySet()) {
                SessionEntity entity = ((SessionEntityWrapper)cache.get((Object)id)).getEntity();
                if (!(entity instanceof UserSessionEntity)) continue;
                UserSessionEntity userSession = (UserSessionEntity)((SessionEntityWrapper)cache.get((Object)id)).getEntity();
                this.log.info((Object)("list: key=" + id + ", value=" + this.toString(userSession)));
            }
        }
    }

    public static class SizeCommand
    extends AbstractSessionCacheCommand {
        @Override
        public String getName() {
            return "size";
        }

        @Override
        protected void doRunCacheCommand(KeycloakSession session, Cache<String, SessionEntityWrapper> cache) {
            this.log.info((Object)("Size: " + cache.size()));
        }
    }

    public static class ClearCommand
    extends AbstractSessionCacheCommand {
        @Override
        public String getName() {
            return "clear";
        }

        @Override
        protected void doRunCacheCommand(KeycloakSession session, Cache<String, SessionEntityWrapper> cache) {
            cache.clear();
        }
    }

    public static class RemoveCommand
    extends AbstractSessionCacheCommand {
        @Override
        public String getName() {
            return "remove";
        }

        @Override
        protected void doRunCacheCommand(KeycloakSession session, Cache<String, SessionEntityWrapper> cache) {
            String id = this.getArg(1);
            cache.remove((Object)id);
        }

        @Override
        public String printUsage() {
            return this.getName() + " <cache-name> <user-session-id>";
        }
    }

    public static class GetMultipleCommand
    extends AbstractSessionCacheCommand {
        @Override
        public String getName() {
            return "getMulti";
        }

        @Override
        protected void doRunCacheCommand(KeycloakSession session, Cache<String, SessionEntityWrapper> cache) {
            String id = this.getArg(1);
            int count = this.getIntArg(2);
            long start = System.currentTimeMillis();
            for (int i = 0; i < count; ++i) {
                UserSessionEntity userSessionEntity = (UserSessionEntity)((SessionEntityWrapper)cache.get((Object)id)).getEntity();
            }
            long took = System.currentTimeMillis() - start;
            this.log.infof("Took %d milliseconds", (Object)took);
        }

        @Override
        public String printUsage() {
            return this.getName() + " <cache-name> <user-session-id> <count-of-gets>";
        }
    }

    public static class GetCommand
    extends AbstractSessionCacheCommand {
        @Override
        public String getName() {
            return "get";
        }

        @Override
        protected void doRunCacheCommand(KeycloakSession session, Cache<String, SessionEntityWrapper> cache) {
            String id = this.getArg(1);
            UserSessionEntity userSession = (UserSessionEntity)((SessionEntityWrapper)cache.get((Object)id)).getEntity();
            this.printSession(id, userSession);
        }

        @Override
        public String printUsage() {
            return this.getName() + " <cache-name> <user-session-id>";
        }
    }

    public static class PutCommand
    extends AbstractSessionCacheCommand {
        @Override
        public String getName() {
            return "put";
        }

        @Override
        protected void doRunCacheCommand(KeycloakSession session, Cache<String, SessionEntityWrapper> cache) {
            UserSessionEntity userSession = new UserSessionEntity();
            String id = this.getArg(1);
            userSession.setId(id);
            userSession.setRealmId(this.getArg(2));
            userSession.setLastSessionRefresh(Time.currentTime());
            cache.put((Object)id, (Object)new SessionEntityWrapper((SessionEntity)userSession));
        }

        @Override
        public String printUsage() {
            return this.getName() + " <cache-name> <user-session-id> <realm-name>";
        }
    }
}

