/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import io.undertow.Undertow;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DefaultServletConfig;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceHandle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.jboss.logging.Logger;
import org.jboss.resteasy.plugins.server.undertow.UndertowJaxrsServer;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.keycloak.common.Version;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.platform.Platform;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.testsuite.UndertowRequestFilter;
import org.keycloak.testsuite.util.cli.TestsuiteCLI;
import org.keycloak.util.JsonSerialization;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;

public class KeycloakServer {
    private static final Logger log = Logger.getLogger(KeycloakServer.class);
    public static final String JBOSS_SERVER_DATA_DIR = "jboss.server.data.dir";
    private boolean sysout = false;
    private KeycloakServerConfig config;
    private KeycloakSessionFactory sessionFactory;
    private UndertowJaxrsServer server;

    public static <T> T loadJson(InputStream is, Class<T> type) {
        try {
            return (T)JsonSerialization.readValue((InputStream)is, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse json", e);
        }
    }

    public static void main(String[] args) throws Throwable {
        if (!System.getenv().containsKey("MAVEN_CMD_LINE_ARGS")) {
            Version.BUILD_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date());
        }
        KeycloakServer.bootstrapKeycloakServer(args);
    }

    public static KeycloakServer bootstrapKeycloakServer(String[] args) throws Throwable {
        File f = new File(System.getProperty("user.home"), ".keycloak-server.properties");
        if (f.isFile()) {
            Properties p = new Properties();
            String[] stringArray = null;
            try (FileInputStream is = new FileInputStream(f);){
                p.load(is);
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
            System.getProperties().putAll((Map<?, ?>)p);
        }
        KeycloakServerConfig config = new KeycloakServerConfig();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-b")) {
                config.setHost(args[++i]);
            }
            if (!args[i].equals("-p")) continue;
            config.setPort(Integer.valueOf(args[++i]));
        }
        if (System.getProperty("keycloak.port") != null) {
            config.setPort(Integer.valueOf(System.getProperty("keycloak.port")));
        }
        if (System.getProperty("keycloak.port.https") != null) {
            config.setPortHttps(Integer.valueOf(System.getProperty("keycloak.port.https")));
        }
        if (System.getProperty("keycloak.bind.address") != null) {
            config.setHost(System.getProperty("keycloak.bind.address"));
        }
        if (System.getenv("KEYCLOAK_DEV_PORT") != null) {
            config.setPort(Integer.valueOf(System.getenv("KEYCLOAK_DEV_PORT")));
        }
        if (System.getProperties().containsKey("resources")) {
            File dir;
            String resources = System.getProperty("resources");
            if (resources == null || resources.equals("") || resources.equals("true")) {
                if (System.getProperties().containsKey("maven.home")) {
                    resources = System.getProperty("user.dir").replaceFirst("testsuite.utils.*", "");
                } else {
                    for (String c : System.getProperty("java.class.path").split(File.pathSeparator)) {
                        if (!c.contains(File.separator + "testsuite" + File.separator + "utils")) continue;
                        resources = c.replaceFirst("testsuite.utils.*", "");
                    }
                }
            }
            if (!(dir = new File(resources).getAbsoluteFile()).isDirectory()) {
                throw new RuntimeException("Invalid base resources directory");
            }
            if (!new File(dir, "themes").isDirectory()) {
                throw new RuntimeException("Invalid resources forms directory");
            }
            if (!System.getProperties().containsKey("keycloak.theme.dir")) {
                System.setProperty("keycloak.theme.dir", KeycloakServer.file(dir.getAbsolutePath(), "themes", "src", "main", "resources", "theme").getAbsolutePath());
            } else {
                String foo = System.getProperty("keycloak.theme.dir");
                System.out.println(foo);
            }
            if (!System.getProperties().containsKey("keycloak.theme.cacheTemplates")) {
                System.setProperty("keycloak.theme.cacheTemplates", "false");
            }
            if (!System.getProperties().containsKey("keycloak.theme.cacheThemes")) {
                System.setProperty("keycloak.theme.cacheThemes", "false");
            }
            if (!System.getProperties().containsKey("keycloak.theme.staticMaxAge")) {
                System.setProperty("keycloak.theme.staticMaxAge", "-1");
            }
            config.setResourcesHome(dir.getAbsolutePath());
        }
        if (System.getProperties().containsKey("undertowWorkerThreads")) {
            int undertowWorkerThreads = Integer.parseInt(System.getProperty("undertowWorkerThreads"));
            config.setWorkerThreads(undertowWorkerThreads);
        }
        KeycloakServer.configureDataDirectory();
        KeycloakServer.detectNodeName(config);
        final KeycloakServer keycloak = new KeycloakServer(config);
        keycloak.sysout = true;
        keycloak.start();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-import")) continue;
            keycloak.importRealm(new FileInputStream(args[++i]));
        }
        if (System.getProperties().containsKey("import")) {
            keycloak.importRealm(new FileInputStream(System.getProperty("import")));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                keycloak.stop();
            }
        });
        if (System.getProperties().containsKey("startTestsuiteCLI")) {
            new TestsuiteCLI(keycloak).start();
        }
        return keycloak;
    }

    public static void configureDataDirectory() {
        String dataPath = KeycloakServer.detectDataDirectory();
        System.setProperty(JBOSS_SERVER_DATA_DIR, dataPath);
        log.infof("Using %s %s", (Object)JBOSS_SERVER_DATA_DIR, (Object)dataPath);
    }

    public static String detectDataDirectory() {
        String dataPath = System.getProperty(JBOSS_SERVER_DATA_DIR);
        if (dataPath != null) {
            File dataDir = new File(dataPath);
            if (!dataDir.exists() || !dataDir.isDirectory()) {
                throw new RuntimeException("Invalid jboss.server.data.dir resources directory: " + dataPath);
            }
            return dataPath;
        }
        try {
            File tempKeycloakFolder = Platform.getPlatform().getTmpDirectory();
            File tmpDataDir = new File(tempKeycloakFolder, "/data");
            if (!tmpDataDir.mkdirs()) {
                throw new IOException("Could not create directory " + tmpDataDir);
            }
            tmpDataDir.deleteOnExit();
            dataPath = tmpDataDir.getAbsolutePath();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not create temporary jboss.server.data.dir", ioe);
        }
        return dataPath;
    }

    public KeycloakServer() {
        this(new KeycloakServerConfig());
    }

    public KeycloakServer(KeycloakServerConfig config) {
        this.config = config;
    }

    public KeycloakSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public UndertowJaxrsServer getServer() {
        return this.server;
    }

    public KeycloakServerConfig getConfig() {
        return this.config;
    }

    public void importRealm(InputStream realm) {
        RealmRepresentation rep = KeycloakServer.loadJson(realm, RealmRepresentation.class);
        this.importRealm(rep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRealm(RealmRepresentation rep) {
        session.getTransactionManager().begin();
        try (KeycloakSession session = this.sessionFactory.create();){
            RealmManager manager = new RealmManager(session);
            if (rep.getId() != null && manager.getRealm(rep.getId()) != null) {
                this.info("Not importing realm " + rep.getRealm() + " realm already exists");
                return;
            }
            if (manager.getRealmByName(rep.getRealm()) != null) {
                this.info("Not importing realm " + rep.getRealm() + " realm already exists");
                return;
            }
            RealmModel realm = manager.importRealm(rep);
            this.info("Imported realm " + realm.getName());
            session.getTransactionManager().commit();
        }
    }

    protected void setupDevConfig() {
        if (System.getProperty("keycloak.createAdminUser", "true").equals("true")) {
            try (KeycloakSession session = this.sessionFactory.create();){
                session.getTransactionManager().begin();
                if (new ApplianceBootstrap(session).isNoMasterUser()) {
                    new ApplianceBootstrap(session).createMasterRealmUser("admin", "admin");
                    log.info((Object)"Created master user with credentials admin:admin");
                }
                session.getTransactionManager().commit();
            }
        }
    }

    public void start() throws Throwable {
        long start = System.currentTimeMillis();
        ResteasyDeployment deployment = new ResteasyDeployment();
        deployment.setApplicationClass(KeycloakApplication.class.getName());
        Undertow.Builder builder = Undertow.builder().addHttpListener(this.config.getPort(), this.config.getHost()).setWorkerThreads(this.config.getWorkerThreads()).setIoThreads(this.config.getWorkerThreads() / 8);
        if (this.config.getPortHttps() != -1) {
            builder = builder.addHttpsListener(this.config.getPortHttps(), this.config.getHost(), this.createSSLContext()).setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED);
        }
        this.server = new UndertowJaxrsServer();
        try {
            this.server.start(builder);
            DeploymentInfo di = this.server.undertowDeployment(deployment, "");
            di.setClassLoader(this.getClass().getClassLoader());
            di.setContextPath("/auth");
            di.setDeploymentName("Keycloak");
            di.setDefaultEncoding("UTF-8");
            di.setDefaultServletConfig(new DefaultServletConfig(true));
            deployment.setProperty("resteasy.disable.html.sanitizer", (Object)true);
            InstanceHandle<Filter> filterInstance = new InstanceHandle<Filter>(){

                public Filter getInstance() {
                    return new UndertowRequestFilter(KeycloakServer.this.sessionFactory);
                }

                public void release() {
                }
            };
            FilterInfo filter = Servlets.filter((String)"SessionFilter", UndertowRequestFilter.class, () -> KeycloakServer.lambda$start$0((InstanceHandle)filterInstance));
            filter.setAsyncSupported(true);
            di.addFilter(filter);
            di.addFilterUrlMapping("SessionFilter", "/*", DispatcherType.REQUEST);
            this.server.deploy(di);
            this.sessionFactory = KeycloakApplication.getSessionFactory();
            this.setupDevConfig();
            if (this.config.getResourcesHome() != null) {
                this.info("Loading resources from " + this.config.getResourcesHome());
            }
            this.info("Started Keycloak (http://" + this.config.getHost() + ":" + this.config.getPort() + "/auth" + (this.config.getPortHttps() > 0 ? ", https://" + this.config.getHost() + ":" + this.config.getPortHttps() + "/auth" : "") + ") in " + (System.currentTimeMillis() - start) + " ms\n");
        }
        catch (RuntimeException e) {
            this.server.stop();
            throw e;
        }
    }

    private void info(String message) {
        if (this.sysout) {
            System.out.println(message);
        } else {
            log.info((Object)message);
        }
    }

    public void stop() {
        this.sessionFactory.close();
        this.server.stop();
        this.info("Stopped Keycloak");
    }

    private static File file(String ... path) {
        StringBuilder s = new StringBuilder();
        for (String p : path) {
            s.append(File.separator);
            s.append(p);
        }
        return new File(s.toString());
    }

    private static void detectNodeName(KeycloakServerConfig config) {
        String nodeName = System.getProperty("jboss.node.name");
        if (nodeName == null) {
            HashMap<Integer, String> nodesCfg = new HashMap<Integer, String>();
            nodesCfg.put(8181, "node1");
            nodesCfg.put(8182, "node2");
            nodeName = (String)nodesCfg.get(config.getPort());
            if (nodeName != null) {
                System.setProperty("jboss.node.name", nodeName);
            }
        }
        if (nodeName != null) {
            log.infof("Node name: %s", (Object)nodeName);
        }
    }

    private SSLContext createSSLContext() throws Exception {
        KeyManager[] keyManagers = this.getKeyManagers();
        if (keyManagers == null) {
            return SSLContext.getDefault();
        }
        TrustManager[] trustManagers = this.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    private KeyManager[] getKeyManagers() throws Exception {
        String keyStorePath = System.getProperty("keycloak.tls.keystore.path");
        if (keyStorePath == null) {
            return null;
        }
        log.infof("Loading keystore from file: %s", (Object)keyStorePath);
        InputStream stream = Files.newInputStream(Paths.get(keyStorePath, new String[0]), new OpenOption[0]);
        if (stream == null) {
            throw new RuntimeException("Could not load keystore");
        }
        try (InputStream is = stream;){
            KeyStore keyStore = KeyStore.getInstance("JKS");
            char[] keyStorePassword = System.getProperty("keycloak.tls.keystore.password", "password").toCharArray();
            keyStore.load(is, keyStorePassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyStorePassword);
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            return keyManagerArray;
        }
    }

    private TrustManager[] getTrustManagers() throws Exception {
        String trustStorePath = System.getProperty("keycloak.tls.truststore.path");
        if (trustStorePath == null) {
            return null;
        }
        log.infof("Loading truststore from file: %s", (Object)trustStorePath);
        InputStream stream = Files.newInputStream(Paths.get(trustStorePath, new String[0]), new OpenOption[0]);
        if (stream == null) {
            throw new RuntimeException("Could not load truststore");
        }
        try (InputStream is = stream;){
            KeyStore keyStore = KeyStore.getInstance("JKS");
            char[] keyStorePassword = System.getProperty("keycloak.tls.truststore.password", "password").toCharArray();
            keyStore.load(is, keyStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            return trustManagerArray;
        }
    }

    private static /* synthetic */ InstanceHandle lambda$start$0(InstanceHandle filterInstance) throws InstantiationException {
        return filterInstance;
    }

    public static class KeycloakServerConfig {
        private String host = "localhost";
        private int port = 8081;
        private int portHttps = -1;
        private int workerThreads = Math.max(Runtime.getRuntime().availableProcessors(), 2) * 8;
        private String resourcesHome;

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public int getPortHttps() {
            return this.portHttps;
        }

        public String getResourcesHome() {
            return this.resourcesHome;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setPortHttps(int portHttps) {
            this.portHttps = portHttps;
        }

        public void setResourcesHome(String resourcesHome) {
            this.resourcesHome = resourcesHome;
        }

        public int getWorkerThreads() {
            return this.workerThreads;
        }

        public void setWorkerThreads(int workerThreads) {
            this.workerThreads = workerThreads;
        }
    }
}

