/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.util.SystemEnvProperties;
import org.keycloak.util.JsonSerialization;

public class JsonConfigProviderFactory
extends org.keycloak.services.util.JsonConfigProviderFactory {
    public static final String SERVER_CONTEXT_CONFIG_PROPERTY_OVERRIDES = "keycloak.server.context.config.property-overrides";

    protected Properties getProperties() {
        return new SystemEnvProperties(this.getPropertyOverrides());
    }

    private Map<String, String> getPropertyOverrides() {
        ServletContext context = (ServletContext)ResteasyProviderFactory.getContextData(ServletContext.class);
        HashMap<String, String> propertyOverridesMap = new HashMap<String, String>();
        String propertyOverrides = context.getInitParameter(SERVER_CONTEXT_CONFIG_PROPERTY_OVERRIDES);
        try {
            if (context.getInitParameter(SERVER_CONTEXT_CONFIG_PROPERTY_OVERRIDES) != null) {
                JsonNode jsonObj = JsonSerialization.mapper.readTree(propertyOverrides);
                jsonObj.fields().forEachRemaining(e -> propertyOverridesMap.put((String)e.getKey(), ((JsonNode)e.getValue()).asText()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return propertyOverridesMap;
    }
}

