/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.cli;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordUserCredentialModel;
import org.keycloak.testsuite.util.cli.AbstractCommand;
import org.keycloak.testsuite.util.cli.BatchTaskRunner;

public class UserCommands {

    public static class GetUser
    extends AbstractCommand {
        @Override
        public String getName() {
            return "getUser";
        }

        @Override
        protected void doRunCommand(KeycloakSession session) {
            String realmName = this.getArg(0);
            String username = this.getArg(1);
            RealmModel realm = session.realms().getRealmByName(realmName);
            if (realm == null) {
                this.log.errorf("Unknown realm: %s", (Object)realmName);
                return;
            }
            UserModel user = session.users().getUserByUsername(realm, username);
            if (user == null) {
                this.log.infof("User '%s' doesn't exist in realm '%s'", (Object)username, (Object)realmName);
            } else {
                List<String> roleMappings = this.getRoleMappings(user);
                this.log.infof("User: ID: '%s', username: '%s', mail: '%s', roles: '%s'", new Object[]{user.getId(), user.getUsername(), user.getEmail(), roleMappings.toString()});
            }
        }

        private List<String> getRoleMappings(UserModel user) {
            return user.getRoleMappingsStream().map(role -> {
                if (role.getContainer() instanceof RealmModel) {
                    return role.getName();
                }
                ClientModel client = (ClientModel)role.getContainer();
                return client.getClientId() + "/" + role.getName();
            }).collect(Collectors.toList());
        }

        @Override
        public String printUsage() {
            return super.printUsage() + " <realm-name> <username>";
        }
    }

    public static class Count
    extends AbstractCommand {
        @Override
        public String getName() {
            return "getUsersCount";
        }

        @Override
        protected void doRunCommand(KeycloakSession session) {
            String realmName = this.getArg(0);
            RealmModel realm = session.realms().getRealmByName(realmName);
            if (realm == null) {
                this.log.errorf("Unknown realm: %s", (Object)realmName);
                return;
            }
            int usersCount = session.users().getUsersCount(realm);
            this.log.infof("Users count in realm %s: %d", (Object)realmName, (Object)usersCount);
        }

        @Override
        public String printUsage() {
            return super.printUsage() + " <realm-name>";
        }
    }

    public static class Remove
    extends AbstractCommand {
        @Override
        public String getName() {
            return "removeUsers";
        }

        @Override
        protected void doRunCommand(KeycloakSession session) {
            String usernamePrefix = this.getArg(0);
            String realmName = this.getArg(1);
            int first = this.getIntArg(2);
            int count = this.getIntArg(3);
            RealmModel realm = session.realms().getRealmByName(realmName);
            if (realm == null) {
                this.log.errorf("Unknown realm: %s", (Object)realmName);
                return;
            }
            int last = first + count;
            for (int counter = first; counter < last; ++counter) {
                String username = usernamePrefix + counter;
                UserModel user = session.users().getUserByUsername(realm, username);
                if (user == null) {
                    this.log.errorf("User '%s' not found", (Object)username);
                    continue;
                }
                session.users().removeUser(realm, user);
            }
            this.log.infof("Users from %s to %s removed", (Object)(usernamePrefix + first), (Object)(usernamePrefix + (last - 1)));
        }

        @Override
        public String printUsage() {
            return super.printUsage() + " <username-prefix> <realm-name> <starting-user-offset> <count> \nExample usage: " + super.printUsage() + " test demo 0 20";
        }
    }

    public static class Create
    extends AbstractCommand {
        private String usernamePrefix;
        private String password;
        private String realmName;
        private String roleNames;

        @Override
        public String getName() {
            return "createUsers";
        }

        @Override
        protected void doRunCommand(KeycloakSession session) {
            this.usernamePrefix = this.getArg(0);
            this.password = this.getArg(1);
            this.realmName = this.getArg(2);
            int first = this.getIntArg(3);
            int count = this.getIntArg(4);
            int batchCount = this.getIntArg(5);
            this.roleNames = this.getArg(6);
            BatchTaskRunner.runInBatches(first, count, batchCount, session.getKeycloakSessionFactory(), this::createUsersInBatch);
            this.log.infof("Command finished. All users from %s to %s created", (Object)(this.usernamePrefix + first), (Object)(this.usernamePrefix + (first + count - 1)));
        }

        private void createUsersInBatch(KeycloakSession session, int first, int count) {
            RealmModel realm = session.realms().getRealmByName(this.realmName);
            if (realm == null) {
                this.log.errorf("Unknown realm: %s", (Object)this.realmName);
                throw new AbstractCommand.HandledException();
            }
            Set<RoleModel> roles = this.findRoles(realm, this.roleNames);
            int last = first + count;
            for (int counter = first; counter < last; ++counter) {
                String username = this.usernamePrefix + counter;
                UserModel user = session.users().addUser(realm, username);
                user.setEnabled(true);
                user.setEmail(username + "@keycloak.org");
                PasswordUserCredentialModel passwordCred = UserCredentialModel.password((String)this.password);
                session.userCredentialManager().updateCredential(realm, user, (CredentialInput)passwordCred);
                for (RoleModel role : roles) {
                    user.grantRole(role);
                }
            }
            this.log.infof("Users from %s to %s created", (Object)(this.usernamePrefix + first), (Object)(this.usernamePrefix + (last - 1)));
        }

        @Override
        public String printUsage() {
            return super.printUsage() + " <username-prefix> <password> <realm-name> <starting-user-offset> <total-count> <batch-size> <realm-roles-list>. \n'total-count' refers to total count of newly created users. 'batch-size' refers to number of created users in each transaction. 'starting-user-offset' refers to starting username offset.\nFor example if 'starting-user-offset' is 15 and total-count is 10 and username-prefix is 'test', it will create users test15, test16, test17, ... , test24\nRoles list is divided by comma (client roles are referenced with format <client-id>/<role-name> )>\nExample usage: " + super.printUsage() + " test test demo 0 500 100 user,admin";
        }

        private Set<RoleModel> findRoles(RealmModel realm, String rolesList) {
            String[] roles;
            HashSet<RoleModel> result = new HashSet<RoleModel>();
            for (String roleName : roles = rolesList.split(",")) {
                RoleModel role;
                if ((roleName = roleName.trim()).contains("/")) {
                    String[] spl = roleName.split("/");
                    ClientModel client = realm.getClientByClientId(spl[0]);
                    if (client == null) {
                        this.log.errorf("Client not found: %s", (Object)spl[0]);
                        throw new AbstractCommand.HandledException();
                    }
                    role = client.getRole(spl[1]);
                } else {
                    role = realm.getRole(roleName);
                }
                if (role == null) {
                    this.log.errorf("Role not found: %s", (Object)roleName);
                    throw new AbstractCommand.HandledException();
                }
                result.add(role);
            }
            return result;
        }
    }
}

