/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.testsuite.KeycloakServer;
import org.keycloak.testsuite.util.cli.AbstractCommand;
import org.keycloak.testsuite.util.cli.AbstractSessionCacheCommand;
import org.keycloak.testsuite.util.cli.CacheCommands;
import org.keycloak.testsuite.util.cli.ClusterProviderTaskCommand;
import org.keycloak.testsuite.util.cli.LdapManyGroupsInitializerCommand;
import org.keycloak.testsuite.util.cli.LdapManyObjectsInitializerCommand;
import org.keycloak.testsuite.util.cli.LoadPersistentSessionsCommand;
import org.keycloak.testsuite.util.cli.PersistSessionsCommand;
import org.keycloak.testsuite.util.cli.RoleCommands;
import org.keycloak.testsuite.util.cli.SyncDummyFederationProviderCommand;
import org.keycloak.testsuite.util.cli.UserCommands;

public class TestsuiteCLI {
    private static final Logger log = Logger.getLogger(TestsuiteCLI.class);
    private static final Class<?>[] BUILTIN_COMMANDS = new Class[]{ExitCommand.class, HelpCommand.class, AbstractSessionCacheCommand.PutCommand.class, AbstractSessionCacheCommand.GetCommand.class, AbstractSessionCacheCommand.GetMultipleCommand.class, AbstractSessionCacheCommand.GetLocalCommand.class, AbstractSessionCacheCommand.SizeLocalCommand.class, AbstractSessionCacheCommand.RemoveCommand.class, AbstractSessionCacheCommand.SizeCommand.class, AbstractSessionCacheCommand.ListCommand.class, AbstractSessionCacheCommand.ClearCommand.class, AbstractSessionCacheCommand.CreateManySessionsCommand.class, AbstractSessionCacheCommand.CreateManySessionsProviderCommand.class, PersistSessionsCommand.class, LoadPersistentSessionsCommand.class, UserCommands.Create.class, UserCommands.Remove.class, UserCommands.Count.class, UserCommands.GetUser.class, SyncDummyFederationProviderCommand.class, RoleCommands.CreateRoles.class, CacheCommands.ListCachesCommand.class, CacheCommands.GetCacheCommand.class, CacheCommands.CacheRealmObjectsCommand.class, ClusterProviderTaskCommand.class, LdapManyObjectsInitializerCommand.class, LdapManyGroupsInitializerCommand.class};
    private final KeycloakSessionFactory sessionFactory;
    private final Map<String, Class<? extends AbstractCommand>> commands = new LinkedHashMap<String, Class<? extends AbstractCommand>>();

    public TestsuiteCLI(KeycloakServer server) {
        this.sessionFactory = server.getSessionFactory();
        Class<?>[] classArray = BUILTIN_COMMANDS;
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> clazz;
            Class<?> commandClazz = clazz = classArray[i];
            try {
                AbstractCommand command = (AbstractCommand)commandClazz.newInstance();
                this.commands.put(command.getName(), commandClazz);
                continue;
            }
            catch (Exception ex) {
                log.error((Object)("Error registering command of class: " + commandClazz.getName()), (Throwable)ex);
            }
        }
    }

    public void registerCommand(String name, Class<? extends AbstractCommand> command) {
        this.commands.put(name, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        log.info((Object)"Starting testsuite CLI. Exit with 'exit' . Available commands with 'help' ");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("$ ");
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] splits = line.split(" ");
                String commandName = splits[0];
                Class<? extends AbstractCommand> commandClass = this.commands.get(commandName);
                if (commandClass == null) {
                    log.errorf("Unknown command: %s", (Object)commandName);
                } else {
                    try {
                        AbstractCommand command = commandClass.newInstance();
                        ArrayList<String> args = new ArrayList<String>(Arrays.asList(splits));
                        args.remove(0);
                        command.injectProperties(args, this, this.sessionFactory);
                        command.runCommand();
                        if (command instanceof ExitCommand) {
                            return;
                        }
                    }
                    catch (InstantiationException ex) {
                        log.error((Object)ex);
                    }
                    catch (IllegalAccessException ex) {
                        log.error((Object)ex);
                    }
                }
                System.out.print("$ ");
            }
        }
        finally {
            log.info((Object)"Exit testsuite CLI");
            reader.close();
        }
    }

    public static class HelpCommand
    extends AbstractCommand {
        private List<String> commandNames = new ArrayList<String>();

        @Override
        public void injectProperties(List<String> args, TestsuiteCLI cli, KeycloakSessionFactory sessionFactory) {
            for (String commandName : cli.commands.keySet()) {
                this.commandNames.add(commandName);
            }
        }

        @Override
        public String getName() {
            return "help";
        }

        @Override
        public void runCommand() {
            this.log.info((Object)("Available commands: " + this.commandNames.toString()));
        }

        @Override
        protected void doRunCommand(KeycloakSession session) {
        }
    }

    public static class ExitCommand
    extends AbstractCommand {
        @Override
        public String getName() {
            return "exit";
        }

        @Override
        public void runCommand() {
        }

        @Override
        protected void doRunCommand(KeycloakSession session) {
        }

        @Override
        public String printUsage() {
            return this.getName();
        }
    }
}

