/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.cli;

import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;

public class TestCacheUtils {
    public static void cacheRealmWithEverything(KeycloakSession session, String realmName) {
        RealmModel realm = session.realms().getRealmByName(realmName);
        realm.getClientsStream().forEach(c -> {
            realm.getClientById(c.getId());
            realm.getClientByClientId(c.getClientId());
            TestCacheUtils.cacheRoles(session, realm, (RoleContainerModel)c);
        });
        TestCacheUtils.cacheRoles(session, realm, (RoleContainerModel)realm);
        realm.getTopLevelGroupsStream().forEach(group -> TestCacheUtils.cacheGroupRecursive(realm, group));
        realm.getClientScopesStream().map(ClientScopeModel::getId).forEach(arg_0 -> ((RealmModel)realm).getClientScopeById(arg_0));
        session.users().getUsersStream(realm).forEach(user -> {
            session.users().getUserById(realm, user.getId());
            if (user.getEmail() != null) {
                session.users().getUserByEmail(realm, user.getEmail());
            }
            session.users().getUserByUsername(realm, user.getUsername());
            session.users().getConsentsStream(realm, user.getId());
            session.users().getFederatedIdentitiesStream(realm, user).forEach(identity -> session.users().getUserByFederatedIdentity(realm, identity));
        });
    }

    private static void cacheRoles(KeycloakSession session, RealmModel realm, RoleContainerModel roleContainer) {
        roleContainer.getRolesStream().forEach(role -> {
            realm.getRoleById(role.getId());
            roleContainer.getRole(role.getName());
            if (roleContainer instanceof RealmModel) {
                session.roles().getRealmRole(realm, role.getName());
            } else {
                session.roles().getClientRole((ClientModel)roleContainer, role.getName());
            }
        });
    }

    private static void cacheGroupRecursive(RealmModel realm, GroupModel group) {
        realm.getGroupById(group.getId());
        group.getSubGroupsStream().forEach(sub -> TestCacheUtils.cacheGroupRecursive(realm, sub));
    }
}

