/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.cli;

import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.testsuite.util.cli.AbstractCommand;
import org.keycloak.testsuite.util.cli.BatchTaskRunner;

public class RoleCommands {

    public static class CreateRoles
    extends AbstractCommand {
        private String rolePrefix;
        private String roleContainer;

        @Override
        public String getName() {
            return "createRoles";
        }

        @Override
        protected void doRunCommand(KeycloakSession session) {
            this.rolePrefix = this.getArg(0);
            this.roleContainer = this.getArg(1);
            int first = this.getIntArg(2);
            int count = this.getIntArg(3);
            int batchCount = this.getIntArg(4);
            BatchTaskRunner.runInBatches(first, count, batchCount, session.getKeycloakSessionFactory(), (bathcSession, firstInThisIteration, countInThisIteration) -> this.createRolesInBatch(session, this.roleContainer, this.rolePrefix, firstInThisIteration, countInThisIteration));
            this.log.infof("Command finished. All roles from %s to %s created", (Object)(this.rolePrefix + first), (Object)(this.rolePrefix + (first + count - 1)));
        }

        private void createRolesInBatch(KeycloakSession session, String roleContainer, String rolePrefix, int first, int count) {
            RoleContainerModel container = this.getRoleContainer(session, roleContainer);
            int last = first + count;
            for (int counter = first; counter < last; ++counter) {
                String roleName = rolePrefix + counter;
                RoleModel roleModel = container.addRole(roleName);
            }
            this.log.infof("Roles from %s to %s created", (Object)(rolePrefix + first), (Object)(rolePrefix + (last - 1)));
        }

        private RoleContainerModel getRoleContainer(KeycloakSession session, String roleContainer) {
            String[] parts = roleContainer.split("/");
            String realmName = parts[0];
            RealmModel realm = session.realms().getRealmByName(realmName);
            if (realm == null) {
                this.log.errorf("Unknown realm: %s", (Object)realmName);
                throw new AbstractCommand.HandledException();
            }
            if (parts.length == 1) {
                return realm;
            }
            String clientId = parts[1];
            ClientModel client = session.clients().getClientByClientId(realm, clientId);
            if (client == null) {
                this.log.errorf("Unknown client: %s", (Object)clientId);
                throw new AbstractCommand.HandledException();
            }
            return client;
        }

        @Override
        public String printUsage() {
            return super.printUsage() + " <role-prefix> <role-container> <starting-role-offset> <total-count> <batch-size> . \n'total-count' refers to total count of newly created roles. 'batch-size' refers to number of created roles in each transaction. 'starting-role-offset' refers to starting role offset.\nFor example if 'starting-role-offset' is 15 and total-count is 10 and role-prefix is 'test', it will create roles test15, test16, test17, ... , test24\n'role-container' is either realm (then use just realmName like 'demo' or client (then use realm/clientId like 'demo/my-client' .\nExample usage: " + super.printUsage() + " test demo 0 500 100";
        }
    }
}

