/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.cli;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.testsuite.util.cli.AbstractCommand;

public class PersistSessionsCommand
extends AbstractCommand {
    private AtomicInteger userCounter = new AtomicInteger();

    @Override
    public String getName() {
        return "persistSessions";
    }

    @Override
    public void doRunCommand(KeycloakSession sess) {
        int createInThisBatch;
        int count = this.getIntArg(0);
        int batchCount = this.getIntArg(1);
        for (int remaining = count; remaining > 0; remaining -= createInThisBatch) {
            createInThisBatch = Math.min(batchCount, remaining);
            this.createSessionsBatch(createInThisBatch);
        }
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                UserSessionPersisterProvider persister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
                PersistSessionsCommand.this.log.info((Object)("Command finished. Total number of sessions in persister: " + persister.getUserSessionsCount(true)));
            }
        });
    }

    private void createSessionsBatch(final int countInThisBatch) {
        final LinkedList userSessionIds = new LinkedList();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                RealmModel realm = session.realms().getRealmByName("master");
                ClientModel testApp = realm.getClientByClientId("security-admin-console");
                UserSessionPersisterProvider persister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
                for (int i = 0; i < countInThisBatch; ++i) {
                    String username = "john-" + PersistSessionsCommand.this.userCounter.incrementAndGet();
                    UserModel john = session.users().getUserByUsername(realm, username);
                    if (john == null) {
                        john = session.users().addUser(realm, username);
                    }
                    UserSessionModel userSession = session.sessions().createUserSession(realm, john, username, "127.0.0.2", "form", true, null, null);
                    AuthenticatedClientSessionModel clientSession = session.sessions().createClientSession(realm, testApp, userSession);
                    clientSession.setRedirectUri("http://redirect");
                    clientSession.setNote("foo", "bar-" + i);
                    userSessionIds.add(userSession.getId());
                }
            }
        });
        this.log.infof("%d sessions created in infinispan storage", (Object)countInThisBatch);
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                RealmModel realm = session.realms().getRealmByName("master");
                ClientModel testApp = realm.getClientByClientId("security-admin-console");
                UserSessionPersisterProvider persister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
                int counter = 0;
                for (String userSessionId : userSessionIds) {
                    ++counter;
                    UserSessionModel userSession = session.sessions().getUserSession(realm, userSessionId);
                    persister.createUserSession(userSession, true);
                    AuthenticatedClientSessionModel clientSession = (AuthenticatedClientSessionModel)userSession.getAuthenticatedClientSessions().get(testApp.getId());
                    persister.createClientSession(clientSession, true);
                }
                PersistSessionsCommand.this.log.infof("%d user sessions persisted. Continue", (Object)counter);
            }
        });
    }

    @Override
    public String printUsage() {
        return super.printUsage() + " <sessions-count> <sessions-count-per-each-transaction>";
    }
}

