/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.cli;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.testsuite.util.cli.AbstractCommand;

public class LoadPersistentSessionsCommand
extends AbstractCommand {
    @Override
    public String getName() {
        return "loadPersistentSessions";
    }

    @Override
    protected void doRunCommand(KeycloakSession session) {
        int workersCount = this.getIntArg(0);
        int limit = this.getIntArg(1);
        AtomicReference<String> lastSessionId = new AtomicReference<String>("abc");
        AtomicBoolean finished = new AtomicBoolean(false);
        int i = 0;
        while (!finished.get()) {
            if (i % 16 == 0) {
                this.log.infof("Starting iteration: %s . lastCreatedOn: %d, lastSessionId: %s", (Object)i, (Object)lastSessionId.get());
            }
            i += workersCount;
            LinkedList<Thread> workers = new LinkedList<Thread>();
            MyWorker lastWorker = null;
            for (int workerId = 0; workerId < workersCount; ++workerId) {
                lastWorker = new MyWorker(workerId, lastSessionId.get(), limit, this.sessionFactory);
                Thread worker = new Thread(lastWorker);
                workers.add(worker);
            }
            for (Thread worker : workers) {
                worker.start();
            }
            for (Thread worker : workers) {
                try {
                    worker.join();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            List lastWorkerSessions = lastWorker.getLoadedSessions();
            if (lastWorkerSessions.size() < limit) {
                finished.set(true);
                continue;
            }
            UserSessionModel lastSession = (UserSessionModel)lastWorkerSessions.get(lastWorkerSessions.size() - 1);
            lastSessionId.set(lastSession.getId());
        }
        this.log.info((Object)"All persistent sessions loaded successfully");
    }

    @Override
    public String printUsage() {
        return super.printUsage() + " <workers-count (for example 8)> <limit (for example 64)>";
    }

    private static class MyWorker
    implements Runnable {
        private final int workerId;
        private final String lastSessionId;
        private final int limit;
        private final KeycloakSessionFactory sessionFactory;
        private List<UserSessionModel> loadedSessions = new LinkedList<UserSessionModel>();

        public MyWorker(int workerId, String lastSessionId, int limit, KeycloakSessionFactory sessionFactory) {
            this.workerId = workerId;
            this.lastSessionId = lastSessionId;
            this.limit = limit;
            this.sessionFactory = sessionFactory;
        }

        @Override
        public void run() {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, keycloakSession -> {
                int offset = this.workerId * this.limit;
                UserSessionPersisterProvider persister = (UserSessionPersisterProvider)keycloakSession.getProvider(UserSessionPersisterProvider.class);
                this.loadedSessions = persister.loadUserSessionsStream(Integer.valueOf(offset), Integer.valueOf(this.limit), true, this.lastSessionId).collect(Collectors.toList());
            });
        }

        private List<UserSessionModel> getLoadedSessions() {
            return this.loadedSessions;
        }
    }
}

