/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.cli;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.testsuite.util.cli.AbstractCommand;

public class ClusterProviderTaskCommand
extends AbstractCommand {
    private static final ExecutorService executors = Executors.newCachedThreadPool();

    @Override
    protected void doRunCommand(KeycloakSession session) {
        String taskName = this.getArg(0);
        int taskTimeout = this.getIntArg(1);
        int sleepTime = this.getIntArg(2);
        ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
        Future future = cluster.executeIfNotExecutedAsync(taskName, taskTimeout, () -> {
            this.log.infof("Started sleeping for " + sleepTime + " seconds", new Object[0]);
            Thread.sleep(sleepTime * 1000);
            this.log.infof("Stopped sleeping", new Object[0]);
            return null;
        });
        this.log.info((Object)"I've retrieved future successfully");
        executors.execute(() -> {
            try {
                future.get();
                this.log.info((Object)"Successfully finished future!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void updateConfig(MultivaluedHashMap<String, String> cfg, int waitTime) {
        cfg.putSingle((Object)"wait-time", (Object)String.valueOf(waitTime));
    }

    @Override
    public String getName() {
        return "clusterProviderTask";
    }

    @Override
    public String printUsage() {
        return super.printUsage() + " <task-name> <task-wait-time-in-seconds> <sleep-time-in-seconds>";
    }
}

