/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.cli;

import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.testsuite.util.cli.AbstractCommand;
import org.keycloak.testsuite.util.cli.TestCacheUtils;

public class CacheCommands {

    public static class CacheRealmObjectsCommand
    extends AbstractCommand {
        @Override
        public String getName() {
            return "cacheRealmObjects";
        }

        @Override
        protected void doRunCommand(KeycloakSession session) {
            String realmName = this.getArg(0);
            RealmModel realm = session.realms().getRealmByName(realmName);
            if (realm == null) {
                this.log.errorf("Realm not found: %s", (Object)realmName);
                throw new AbstractCommand.HandledException();
            }
            TestCacheUtils.cacheRealmWithEverything(session, realmName);
        }

        @Override
        public String printUsage() {
            return super.printUsage() + " <realm-name>";
        }
    }

    public static class GetCacheCommand
    extends AbstractCommand {
        @Override
        public String getName() {
            return "getCache";
        }

        @Override
        protected void doRunCommand(KeycloakSession session) {
            String cacheName = this.getArg(0);
            InfinispanConnectionProvider ispnProvider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
            Cache cache = ispnProvider.getCache(cacheName);
            if (cache == null) {
                this.log.errorf("Cache '%s' doesn't exist", (Object)cacheName);
                throw new AbstractCommand.HandledException();
            }
            this.printCache((Cache<Object, Object>)cache);
        }

        private void printCache(Cache<Object, Object> cache) {
            int size = cache.size();
            this.log.infof("Cache %s, size: %d", (Object)cache.getName(), (Object)size);
            if (size > 50) {
                this.log.info((Object)"Skip printing cache records due to big size");
            } else {
                for (Map.Entry entry : cache.entrySet()) {
                    this.log.infof("%s=%s", entry.getKey(), entry.getValue());
                }
            }
        }

        @Override
        public String printUsage() {
            return super.printUsage() + " <cache-name> . cache-name is name of the infinispan cache provided by InfinispanConnectionProvider";
        }
    }

    public static class ListCachesCommand
    extends AbstractCommand {
        @Override
        public String getName() {
            return "listCaches";
        }

        @Override
        protected void doRunCommand(KeycloakSession session) {
            InfinispanConnectionProvider ispnProvider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
            Set cacheNames = ispnProvider.getCache("realms").getCacheManager().getCacheNames();
            this.log.infof("Available caches: %s", (Object)cacheNames);
        }
    }
}

