/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.cli;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.testsuite.util.cli.TestsuiteCLI;

public abstract class AbstractCommand {
    protected final Logger log = Logger.getLogger((String)this.getClass().getName());
    protected List<String> args;
    protected KeycloakSessionFactory sessionFactory;

    public void injectProperties(List<String> args, TestsuiteCLI cli, KeycloakSessionFactory sessionFactory) {
        this.args = args;
        this.sessionFactory = sessionFactory;
    }

    public void runCommand() {
        try {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    AbstractCommand.this.doRunCommand(session);
                }
            });
        }
        catch (HandledException handledException) {
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Error occured during command. ", (Throwable)e);
        }
    }

    public abstract String getName();

    protected abstract void doRunCommand(KeycloakSession var1);

    protected String getArg(int index) {
        try {
            return this.args.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            this.log.errorf("Usage: %s", (Object)this.printUsage());
            throw new HandledException();
        }
    }

    protected Integer getIntArg(int index) {
        String str = this.getArg(index);
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nex) {
            this.log.errorf("Usage: %s", (Object)this.printUsage());
            throw new HandledException();
        }
    }

    public String printUsage() {
        return this.getName();
    }

    public static class HandledException
    extends RuntimeException {
    }
}

