/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.filters.AbstractRequestFilter;

public class UndertowRequestFilter
extends AbstractRequestFilter
implements Filter {
    private final KeycloakSessionFactory factory;

    public UndertowRequestFilter(KeycloakSessionFactory factory) {
        this.factory = factory;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws UnsupportedEncodingException {
        servletRequest.setCharacterEncoding("UTF-8");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        this.filter(this.createClientConnection(request), session -> {
            try {
                filterChain.doFilter(servletRequest, servletResponse);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private ClientConnection createClientConnection(final HttpServletRequest request) {
        return new ClientConnection(){

            public String getRemoteAddr() {
                String forwardedFor = request.getHeader("X-Forwarded-For");
                if (forwardedFor != null) {
                    return forwardedFor;
                }
                return request.getRemoteAddr();
            }

            public String getRemoteHost() {
                return request.getRemoteHost();
            }

            public int getRemotePort() {
                return request.getRemotePort();
            }

            public String getLocalAddr() {
                return request.getLocalAddr();
            }

            public int getLocalPort() {
                return request.getLocalPort();
            }
        };
    }

    protected KeycloakSessionFactory getSessionFactory() {
        return this.factory;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

