/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.jboss.logging.Logger;
import org.keycloak.platform.PlatformProvider;

public class TestPlatform
implements PlatformProvider {
    private static final Logger log = Logger.getLogger(TestPlatform.class);
    private File tmpDir;

    public void onStartup(Runnable startupHook) {
        startupHook.run();
    }

    public void onShutdown(Runnable shutdownHook) {
    }

    public void exit(Throwable cause) {
        throw new RuntimeException(cause);
    }

    public File getTmpDirectory() {
        if (this.tmpDir == null) {
            File tmpDir;
            String projectBuildDir = System.getProperty("project.build.directory");
            if (projectBuildDir != null) {
                tmpDir = new File(projectBuildDir, "server-tmp");
                tmpDir.mkdir();
            } else {
                try {
                    tmpDir = Files.createTempDirectory("keycloak-server-", new FileAttribute[0]).toFile();
                    tmpDir.deleteOnExit();
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Could not create temporary directory", ioe);
                }
            }
            if (tmpDir.isDirectory()) {
                this.tmpDir = tmpDir;
                log.infof("Using server tmp directory: %s", (Object)tmpDir.getAbsolutePath());
            } else {
                throw new RuntimeException("Directory " + tmpDir + " was not created and does not exists");
            }
        }
        return this.tmpDir;
    }
}

