/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.kerberos.KerberosConfig;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.sasl.MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.digestMD5.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.gssapi.GssapiMechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.plain.PlainMechanismHandler;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.KerberosUtils;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.jboss.logging.Logger;
import org.keycloak.util.ldap.LDAPEmbeddedServer;

public class KerberosEmbeddedServer
extends LDAPEmbeddedServer {
    private static final Logger log = Logger.getLogger(KerberosEmbeddedServer.class);
    public static final String PROPERTY_KERBEROS_REALM = "kerberos.realm";
    public static final String PROPERTY_KDC_PORT = "kerberos.port";
    public static final String PROPERTY_KDC_ENCTYPES = "kerberos.encTypes";
    private static final String DEFAULT_KERBEROS_LDIF_FILE = "classpath:kerberos/default-users.ldif";
    public static final String DEFAULT_KERBEROS_REALM = "KEYCLOAK.ORG";
    public static final String DEFAULT_KERBEROS_REALM_2 = "KC2.COM";
    private static final String DEFAULT_KDC_PORT = "6088";
    private static final String DEFAULT_KDC_ENCRYPTION_TYPES = "aes128-cts-hmac-sha1-96, des-cbc-md5, des3-cbc-sha1-kd";
    private final String kerberosRealm;
    private final int kdcPort;
    private final String kdcEncryptionTypes;
    private KdcServer kdcServer;

    public static void main(String[] args) throws Exception {
        Properties defaultProperties = new Properties();
        defaultProperties.put("ldap.dsf", "file");
        String kerberosRealm = System.getProperty("keycloak.kerberos.realm", DEFAULT_KERBEROS_REALM);
        KerberosEmbeddedServer.configureDefaultPropertiesForRealm(kerberosRealm, defaultProperties);
        KerberosEmbeddedServer.execute(args, defaultProperties);
    }

    public static void configureDefaultPropertiesForRealm(String kerberosRealm, Properties properties) {
        log.infof("Using kerberos realm: %s", (Object)kerberosRealm);
        if (!DEFAULT_KERBEROS_REALM.equals(kerberosRealm)) {
            if (DEFAULT_KERBEROS_REALM_2.equals(kerberosRealm)) {
                properties.put("ldap.baseDN", "dc=kc2,dc=com");
                properties.put("ldap.port", "11389");
                properties.put("ldaps.port", "11636");
                properties.put("ldap.ldif", "classpath:kerberos/default-users-kc2.ldif");
                properties.put(PROPERTY_KERBEROS_REALM, DEFAULT_KERBEROS_REALM_2);
                properties.put(PROPERTY_KDC_PORT, "7088");
            } else {
                throw new IllegalArgumentException("Valid values for kerberos realm are [ KEYCLOAK.ORG , KC2.COM ]");
            }
        }
    }

    public static void execute(String[] args, Properties defaultProperties) throws Exception {
        final KerberosEmbeddedServer kerberosEmbeddedServer = new KerberosEmbeddedServer(defaultProperties);
        kerberosEmbeddedServer.init();
        kerberosEmbeddedServer.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    kerberosEmbeddedServer.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public KerberosEmbeddedServer(Properties defaultProperties) {
        super(defaultProperties);
        this.ldifFile = this.readProperty("ldap.ldif", DEFAULT_KERBEROS_LDIF_FILE);
        this.kerberosRealm = this.readProperty(PROPERTY_KERBEROS_REALM, DEFAULT_KERBEROS_REALM);
        String kdcPort = this.readProperty(PROPERTY_KDC_PORT, DEFAULT_KDC_PORT);
        this.kdcPort = Integer.parseInt(kdcPort);
        this.kdcEncryptionTypes = this.readProperty(PROPERTY_KDC_ENCTYPES, DEFAULT_KDC_ENCRYPTION_TYPES);
        if (this.ldapSaslPrincipal == null || this.ldapSaslPrincipal.isEmpty()) {
            String hostname = this.getHostnameForSASLPrincipal(this.bindHost);
            this.ldapSaslPrincipal = "ldap/" + hostname + "@" + this.kerberosRealm;
        }
    }

    public void init() throws Exception {
        super.init();
        log.info((Object)("Creating KDC server. kerberosRealm: " + this.kerberosRealm + ", kdcPort: " + this.kdcPort + ", kdcEncryptionTypes: " + this.kdcEncryptionTypes));
        this.createAndStartKdcServer();
    }

    protected DirectoryService createDirectoryService() throws Exception {
        DirectoryService directoryService = super.createDirectoryService();
        directoryService.addLast((Interceptor)new KeyDerivationInterceptor());
        return directoryService;
    }

    protected LdapServer createLdapServer() {
        LdapServer ldapServer = super.createLdapServer();
        ldapServer.setSaslHost(this.bindHost);
        ldapServer.setSaslPrincipal(this.ldapSaslPrincipal);
        ldapServer.setSaslRealms(new ArrayList());
        ldapServer.addSaslMechanismHandler("PLAIN", (MechanismHandler)new PlainMechanismHandler());
        ldapServer.addSaslMechanismHandler("CRAM-MD5", (MechanismHandler)new CramMd5MechanismHandler());
        ldapServer.addSaslMechanismHandler("DIGEST-MD5", (MechanismHandler)new DigestMd5MechanismHandler());
        ldapServer.addSaslMechanismHandler("GSSAPI", (MechanismHandler)new GssapiMechanismHandler());
        ldapServer.addSaslMechanismHandler("NTLM", (MechanismHandler)new NtlmMechanismHandler());
        ldapServer.addSaslMechanismHandler("GSS-SPNEGO", (MechanismHandler)new NtlmMechanismHandler());
        return ldapServer;
    }

    protected KdcServer createAndStartKdcServer() throws Exception {
        KerberosConfig kdcConfig = new KerberosConfig();
        kdcConfig.setServicePrincipal("krbtgt/" + this.kerberosRealm + "@" + this.kerberosRealm);
        kdcConfig.setPrimaryRealm(this.kerberosRealm);
        kdcConfig.setMaximumTicketLifetime(86400000L);
        kdcConfig.setMaximumRenewableLifetime(604800000L);
        kdcConfig.setPaEncTimestampRequired(false);
        Set<EncryptionType> encryptionTypes = this.convertEncryptionTypes();
        kdcConfig.setEncryptionTypes(encryptionTypes);
        this.kdcServer = new NoReplayKdcServer(kdcConfig);
        this.kdcServer.setSearchBaseDn(this.baseDN);
        UdpTransport udp = new UdpTransport(this.bindHost, this.kdcPort);
        this.kdcServer.addTransports(new Transport[]{udp});
        this.kdcServer.setDirectoryService(this.directoryService);
        this.kdcServer.start();
        return this.kdcServer;
    }

    public void stop() throws Exception {
        this.stopLdapServer();
        this.stopKerberosServer();
        this.shutdownDirectoryService();
    }

    protected void stopKerberosServer() {
        log.info((Object)"Stopping Kerberos server.");
        this.kdcServer.stop();
    }

    private Set<EncryptionType> convertEncryptionTypes() {
        String[] configEncTypes;
        HashSet<EncryptionType> encryptionTypes = new HashSet();
        for (String enc : configEncTypes = this.kdcEncryptionTypes.split(",")) {
            enc = enc.trim();
            for (EncryptionType type : EncryptionType.getEncryptionTypes()) {
                if (!type.getName().equalsIgnoreCase(enc)) continue;
                encryptionTypes.add(type);
            }
        }
        encryptionTypes = KerberosUtils.orderEtypesByStrength(encryptionTypes);
        return encryptionTypes;
    }

    private String getHostnameForSASLPrincipal(String hostName) {
        try {
            String canonicalized = InetAddress.getByName(hostName).getCanonicalHostName();
            if (canonicalized.toLowerCase(Locale.ENGLISH).startsWith(hostName.toLowerCase(Locale.ENGLISH) + ".")) {
                hostName = canonicalized;
            }
        }
        catch (SecurityException | UnknownHostException exception) {
            // empty catch block
        }
        return hostName.toLowerCase(Locale.ENGLISH);
    }

    static class NoReplayKdcServer
    extends KdcServer {
        NoReplayKdcServer(KerberosConfig kdcConfig) {
            super(kdcConfig);
        }

        public void start() throws IOException, LdapInvalidDnException {
            super.start();
            try {
                Field replayCacheField = KdcServer.class.getDeclaredField("replayCache");
                replayCacheField.setAccessible(true);
                replayCacheField.set((Object)this, new DummyReplayCache());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private class DummyReplayCache
        implements ReplayCache {
            private DummyReplayCache() {
            }

            public boolean isReplay(KerberosPrincipal serverPrincipal, KerberosPrincipal clientPrincipal, KerberosTime clientTime, int clientMicroSeconds) {
                return false;
            }

            public void save(KerberosPrincipal serverPrincipal, KerberosPrincipal clientPrincipal, KerberosTime clientTime, int clientMicroSeconds) {
            }

            public void clear() {
            }
        }
    }
}

