/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.Constants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.oidc.mappers.UserSessionNoteMapper;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.representations.adapters.config.BaseRealmConfig;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.sessions.AuthenticationSessionProvider;

public class ClientManager {
    private static final Logger logger = Logger.getLogger(ClientManager.class);
    protected RealmManager realmManager;

    public ClientManager(RealmManager realmManager) {
        this.realmManager = realmManager;
    }

    public ClientManager() {
    }

    public static ClientModel createClient(KeycloakSession session, RealmModel realm, ClientRepresentation rep) {
        ClientModel client = RepresentationToModel.createClient((KeycloakSession)session, (RealmModel)realm, (ClientRepresentation)rep);
        if (rep.getProtocol() != null) {
            LoginProtocolFactory providerFactory = (LoginProtocolFactory)session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, rep.getProtocol());
            providerFactory.setupClientDefaults(rep, client);
        }
        if (rep.getProtocolMappers() == null && rep.getClientTemplate() != null) {
            client.getProtocolMappersStream().collect(Collectors.toList()).forEach(arg_0 -> ((ClientModel)client).removeProtocolMapper(arg_0));
        }
        return client;
    }

    public boolean removeClient(RealmModel realm, ClientModel client) {
        if (!this.isInternalClient(realm.getName(), client.getClientId()) && realm.removeClient(client.getId())) {
            UserModel serviceAccountUser;
            AuthenticationSessionProvider authSessions;
            UserSessionProvider sessions = this.realmManager.getSession().sessions();
            if (sessions != null) {
                sessions.onClientRemoved(realm, client);
            }
            if ((authSessions = this.realmManager.getSession().authenticationSessions()) != null) {
                authSessions.onClientRemoved(realm, client);
            }
            if ((serviceAccountUser = this.realmManager.getSession().users().getServiceAccount(client)) != null) {
                new UserManager(this.realmManager.getSession()).removeUser(realm, serviceAccountUser);
            }
            return true;
        }
        return false;
    }

    public Set<String> validateRegisteredNodes(ClientModel client) {
        Map registeredNodes = client.getRegisteredNodes();
        if (registeredNodes == null || registeredNodes.isEmpty()) {
            return Collections.emptySet();
        }
        int currentTime = Time.currentTime();
        TreeSet<String> validatedNodes = new TreeSet<String>();
        if (client.getNodeReRegistrationTimeout() > 0) {
            LinkedList toRemove = new LinkedList();
            for (Map.Entry entry : registeredNodes.entrySet()) {
                Integer lastReRegistration = (Integer)entry.getValue();
                if (lastReRegistration + client.getNodeReRegistrationTimeout() < currentTime) {
                    toRemove.add(entry.getKey());
                    continue;
                }
                validatedNodes.add((String)entry.getKey());
            }
            for (String node : toRemove) {
                client.unregisterNode(node);
            }
        } else {
            validatedNodes.addAll(registeredNodes.keySet());
        }
        return validatedNodes;
    }

    public void enableServiceAccount(ClientModel client) {
        ProtocolMapperModel protocolMapper;
        client.setServiceAccountsEnabled(true);
        if (this.realmManager.getSession().users().getServiceAccount(client) == null) {
            String username = "service-account-" + client.getClientId();
            logger.debugf("Creating service account user '%s'", (Object)username);
            UserModel user = this.realmManager.getSession().userLocalStorage().addUser(client.getRealm(), username);
            user.setEnabled(true);
            user.setServiceAccountClientLink(client.getId());
        }
        if (client.getProtocolMapperByName("openid-connect", "Client ID") == null) {
            logger.debugf("Creating service account protocol mapper '%s' for client '%s'", (Object)"Client ID", (Object)client.getClientId());
            protocolMapper = UserSessionNoteMapper.createClaimMapper("Client ID", "clientId", "clientId", "String", true, true);
            client.addProtocolMapper(protocolMapper);
        }
        if (client.getProtocolMapperByName("openid-connect", "Client Host") == null) {
            logger.debugf("Creating service account protocol mapper '%s' for client '%s'", (Object)"Client Host", (Object)client.getClientId());
            protocolMapper = UserSessionNoteMapper.createClaimMapper("Client Host", "clientHost", "clientHost", "String", true, true);
            client.addProtocolMapper(protocolMapper);
        }
        if (client.getProtocolMapperByName("openid-connect", "Client IP Address") == null) {
            logger.debugf("Creating service account protocol mapper '%s' for client '%s'", (Object)"Client IP Address", (Object)client.getClientId());
            protocolMapper = UserSessionNoteMapper.createClaimMapper("Client IP Address", "clientAddress", "clientAddress", "String", true, true);
            client.addProtocolMapper(protocolMapper);
        }
    }

    public void clientIdChanged(ClientModel client, ClientRepresentation newClientRepresentation) {
        String newClientId = newClientRepresentation.getClientId();
        logger.debugf("Updating clientId from '%s' to '%s'", (Object)client.getClientId(), (Object)newClientId);
        UserModel serviceAccountUser = this.realmManager.getSession().users().getServiceAccount(client);
        if (serviceAccountUser != null) {
            String username = "service-account-" + newClientId;
            serviceAccountUser.setUsername(username);
        }
        if ("saml".equals(client.getProtocol())) {
            SamlClient samlClient = new SamlClient(client);
            samlClient.setArtifactBindingIdentifierFrom(newClientId);
            newClientRepresentation.getAttributes().put("saml.artifact.binding.identifier", samlClient.getArtifactBindingIdentifier());
        }
    }

    public InstallationAdapterConfig toInstallationRepresentation(RealmModel realmModel, ClientModel clientModel, URI baseUri) {
        InstallationAdapterConfig rep = new InstallationAdapterConfig();
        rep.setAuthServerUrl(baseUri.toString());
        rep.setRealm(realmModel.getName());
        rep.setSslRequired(realmModel.getSslRequired().name().toLowerCase());
        if (clientModel.isPublicClient() && !clientModel.isBearerOnly()) {
            rep.setPublicClient(true);
        }
        if (clientModel.isBearerOnly()) {
            rep.setBearerOnly(true);
        }
        if (clientModel.getRolesStream().count() > 0L) {
            rep.setUseResourceRoleMappings(true);
        }
        rep.setResource(clientModel.getClientId());
        if (this.showClientCredentialsAdapterConfig(clientModel)) {
            Map<String, Object> adapterConfig = this.getClientCredentialsAdapterConfig(clientModel);
            rep.setCredentials(adapterConfig);
        }
        return rep;
    }

    public String toJBossSubsystemConfig(RealmModel realmModel, ClientModel clientModel, URI baseUri) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<secure-deployment name=\"WAR MODULE NAME.war\">\n");
        buffer.append("    <realm>").append(realmModel.getName()).append("</realm>\n");
        buffer.append("    <auth-server-url>").append(baseUri.toString()).append("</auth-server-url>\n");
        if (clientModel.isBearerOnly()) {
            buffer.append("    <bearer-only>true</bearer-only>\n");
        } else if (clientModel.isPublicClient()) {
            buffer.append("    <public-client>true</public-client>\n");
        }
        buffer.append("    <ssl-required>").append(realmModel.getSslRequired().name()).append("</ssl-required>\n");
        buffer.append("    <resource>").append(clientModel.getClientId()).append("</resource>\n");
        String cred = clientModel.getSecret();
        if (this.showClientCredentialsAdapterConfig(clientModel)) {
            Map<String, Object> adapterConfig = this.getClientCredentialsAdapterConfig(clientModel);
            for (Map.Entry<String, Object> entry : adapterConfig.entrySet()) {
                buffer.append("    <credential name=\"" + entry.getKey() + "\">");
                Object value = entry.getValue();
                if (value instanceof Map) {
                    buffer.append("\n");
                    Map asMap = (Map)value;
                    for (Map.Entry credEntry : asMap.entrySet()) {
                        buffer.append("        <" + (String)credEntry.getKey() + ">" + credEntry.getValue().toString() + "</" + (String)credEntry.getKey() + ">\n");
                    }
                    buffer.append("    </credential>\n");
                    continue;
                }
                buffer.append(value.toString()).append("</credential>\n");
            }
        }
        if (clientModel.getRolesStream().count() > 0L) {
            buffer.append("    <use-resource-role-mappings>true</use-resource-role-mappings>\n");
        }
        buffer.append("</secure-deployment>\n");
        return buffer.toString();
    }

    private boolean showClientCredentialsAdapterConfig(ClientModel client) {
        if (client.isPublicClient()) {
            return false;
        }
        return !client.isBearerOnly() || client.getNodeReRegistrationTimeout() > 0;
    }

    private Map<String, Object> getClientCredentialsAdapterConfig(ClientModel client) {
        String clientAuthenticator = client.getClientAuthenticatorType();
        ClientAuthenticatorFactory authenticator = (ClientAuthenticatorFactory)this.realmManager.getSession().getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, clientAuthenticator);
        return authenticator.getAdapterConfiguration(client);
    }

    private boolean isInternalClient(String realmName, String clientId) {
        if (Constants.defaultClients.contains(clientId)) {
            return true;
        }
        if (!"master".equals(realmName)) {
            return false;
        }
        String internalClientSuffix = "-realm";
        if (clientId.endsWith("-realm")) {
            return this.realmManager.getSession().realms().getRealmByName(clientId.substring(0, clientId.length() - "-realm".length())) != null;
        }
        return false;
    }

    @JsonPropertyOrder(value={"realm", "realm-public-key", "bearer-only", "auth-server-url", "ssl-required", "resource", "public-client", "verify-token-audience", "credentials", "use-resource-role-mappings"})
    public static class InstallationAdapterConfig
    extends BaseRealmConfig {
        @JsonProperty(value="resource")
        protected String resource;
        @JsonProperty(value="use-resource-role-mappings")
        protected Boolean useResourceRoleMappings;
        @JsonProperty(value="bearer-only")
        protected Boolean bearerOnly;
        @JsonProperty(value="public-client")
        protected Boolean publicClient;
        @JsonProperty(value="credentials")
        protected Map<String, Object> credentials;
        @JsonProperty(value="verify-token-audience")
        protected Boolean verifyTokenAudience;
        @JsonProperty(value="policy-enforcer")
        protected PolicyEnforcerConfig enforcerConfig;

        public Boolean isUseResourceRoleMappings() {
            return this.useResourceRoleMappings;
        }

        public void setUseResourceRoleMappings(Boolean useResourceRoleMappings) {
            this.useResourceRoleMappings = useResourceRoleMappings;
        }

        public String getResource() {
            return this.resource;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }

        public Map<String, Object> getCredentials() {
            return this.credentials;
        }

        public void setCredentials(Map<String, Object> credentials) {
            this.credentials = credentials;
        }

        public Boolean getVerifyTokenAudience() {
            return this.verifyTokenAudience;
        }

        public void setVerifyTokenAudience(Boolean verifyTokenAudience) {
            this.verifyTokenAudience = verifyTokenAudience;
        }

        public Boolean getPublicClient() {
            return this.publicClient;
        }

        public void setPublicClient(Boolean publicClient) {
            this.publicClient = publicClient;
        }

        public Boolean getBearerOnly() {
            return this.bearerOnly;
        }

        public void setBearerOnly(Boolean bearerOnly) {
            this.bearerOnly = bearerOnly;
        }

        public PolicyEnforcerConfig getEnforcerConfig() {
            return this.enforcerConfig;
        }

        public void setEnforcerConfig(PolicyEnforcerConfig enforcerConfig) {
            this.enforcerConfig = enforcerConfig;
        }
    }
}

