/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker.installation;

import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.ClientInstallationProvider;

public class DockerVariableOverrideInstallationProvider
implements ClientInstallationProvider {
    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "docker-v2-variable-override";
    }

    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI serverBaseUri) {
        StringBuilder builder = new StringBuilder().append("-e REGISTRY_AUTH_TOKEN_REALM=").append(serverBaseUri).append("/realms/").append(realm.getName()).append("/protocol/").append("docker-v2").append("/auth \\\n").append("-e REGISTRY_AUTH_TOKEN_SERVICE=").append(client.getClientId()).append(" \\\n").append("-e REGISTRY_AUTH_TOKEN_ISSUER=").append(serverBaseUri).append("/realms/").append(realm.getName()).append(" \\\n");
        return Response.ok((Object)builder.toString(), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    public String getProtocol() {
        return "docker-v2";
    }

    public String getDisplayType() {
        return "Variable Override";
    }

    public String getHelpText() {
        return "Configures environment variable overrides, typically used with a docker-compose.yaml configuration for a docker registry";
    }

    public String getFilename() {
        return "docker-env.txt";
    }

    public String getMediaType() {
        return "text/plain";
    }

    public boolean isDownloadOnly() {
        return false;
    }
}

