/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.UserCredentialStoreManager;
import org.keycloak.jose.jws.DefaultTokenManager;
import org.keycloak.keys.DefaultKeyManager;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientScopeProvider;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.ThemeManager;
import org.keycloak.models.TokenManager;
import org.keycloak.models.UserCredentialManager;
import org.keycloak.models.UserLoginFailureProvider;
import org.keycloak.models.UserProvider;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.services.DefaultKeycloakContext;
import org.keycloak.services.DefaultKeycloakSessionFactory;
import org.keycloak.services.DefaultKeycloakTransactionManager;
import org.keycloak.services.clientpolicy.ClientPolicyManager;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.storage.ClientScopeStorageManager;
import org.keycloak.storage.ClientStorageManager;
import org.keycloak.storage.GroupStorageManager;
import org.keycloak.storage.RoleStorageManager;
import org.keycloak.storage.UserStorageManager;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.vault.DefaultVaultTranscriber;
import org.keycloak.vault.VaultProvider;
import org.keycloak.vault.VaultTranscriber;

public class DefaultKeycloakSession
implements KeycloakSession {
    private final DefaultKeycloakSessionFactory factory;
    private final Map<Integer, Provider> providers = new HashMap<Integer, Provider>();
    private final List<Provider> closable = new LinkedList<Provider>();
    private final DefaultKeycloakTransactionManager transactionManager;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<InvalidationHandler.InvalidableObjectType, Set<Object>> invalidationMap = new HashMap<InvalidationHandler.InvalidableObjectType, Set<Object>>();
    private RealmProvider model;
    private ClientProvider clientProvider;
    private ClientScopeProvider clientScopeProvider;
    private GroupProvider groupProvider;
    private RoleProvider roleProvider;
    private UserStorageManager userStorageManager;
    private ClientStorageManager clientStorageManager;
    private ClientScopeStorageManager clientScopeStorageManager;
    private RoleStorageManager roleStorageManager;
    private GroupStorageManager groupStorageManager;
    private UserCredentialStoreManager userCredentialStorageManager;
    private UserSessionProvider sessionProvider;
    private UserLoginFailureProvider userLoginFailureProvider;
    private AuthenticationSessionProvider authenticationSessionProvider;
    private UserFederatedStorageProvider userFederatedStorageProvider;
    private KeycloakContext context;
    private KeyManager keyManager;
    private ThemeManager themeManager;
    private TokenManager tokenManager;
    private VaultTranscriber vaultTranscriber;
    private ClientPolicyManager clientPolicyManager;

    public DefaultKeycloakSession(DefaultKeycloakSessionFactory factory) {
        this.factory = factory;
        this.transactionManager = new DefaultKeycloakTransactionManager(this);
        this.context = new DefaultKeycloakContext(this);
    }

    public KeycloakContext getContext() {
        return this.context;
    }

    private RealmProvider getRealmProvider() {
        CacheRealmProvider cache = this.getProvider(CacheRealmProvider.class);
        if (cache != null) {
            return cache;
        }
        return this.getProvider(RealmProvider.class);
    }

    private ClientProvider getClientProvider() {
        ClientProvider cache = (ClientProvider)this.getProvider(CacheRealmProvider.class);
        if (cache != null) {
            return cache;
        }
        return this.clientStorageManager();
    }

    private ClientScopeProvider getClientScopeProvider() {
        ClientScopeProvider cache = (ClientScopeProvider)this.getProvider(CacheRealmProvider.class);
        if (cache != null) {
            return cache;
        }
        return this.clientScopeStorageManager();
    }

    private GroupProvider getGroupProvider() {
        GroupProvider cache = (GroupProvider)this.getProvider(CacheRealmProvider.class);
        if (cache != null) {
            return cache;
        }
        return this.groupStorageManager();
    }

    private RoleProvider getRoleProvider() {
        RoleProvider cache = (RoleProvider)this.getProvider(CacheRealmProvider.class);
        if (cache != null) {
            return cache;
        }
        return this.roleStorageManager();
    }

    public UserCache userCache() {
        return this.getProvider(UserCache.class);
    }

    public void invalidate(InvalidationHandler.InvalidableObjectType type, Object ... ids) {
        this.factory.invalidate(type, ids);
        this.invalidationMap.computeIfAbsent(type, o -> new HashSet()).addAll(Arrays.asList(ids));
    }

    public void enlistForClose(Provider provider) {
        this.closable.add(provider);
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public <T> T getAttribute(String attribute, Class<T> clazz) {
        Object value = this.getAttribute(attribute);
        return (T)(clazz.isInstance(value) ? value : null);
    }

    public Object removeAttribute(String attribute) {
        return this.attributes.remove(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public KeycloakTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public KeycloakSessionFactory getKeycloakSessionFactory() {
        return this.factory;
    }

    public UserFederatedStorageProvider userFederatedStorage() {
        if (this.userFederatedStorageProvider == null) {
            this.userFederatedStorageProvider = this.getProvider(UserFederatedStorageProvider.class);
        }
        return this.userFederatedStorageProvider;
    }

    public UserProvider userLocalStorage() {
        return this.getProvider(UserProvider.class);
    }

    public RealmProvider realmLocalStorage() {
        return this.getProvider(RealmProvider.class);
    }

    public ClientProvider clientLocalStorage() {
        return this.getProvider(ClientProvider.class);
    }

    public ClientScopeProvider clientScopeLocalStorage() {
        return this.getProvider(ClientScopeProvider.class);
    }

    public GroupProvider groupLocalStorage() {
        return this.getProvider(GroupProvider.class);
    }

    public ClientProvider clientStorageManager() {
        if (this.clientStorageManager == null) {
            this.clientStorageManager = new ClientStorageManager(this, this.factory.getClientStorageProviderTimeout());
        }
        return this.clientStorageManager;
    }

    public ClientScopeProvider clientScopeStorageManager() {
        if (this.clientScopeStorageManager == null) {
            this.clientScopeStorageManager = new ClientScopeStorageManager(this);
        }
        return this.clientScopeStorageManager;
    }

    public RoleProvider roleLocalStorage() {
        return this.getProvider(RoleProvider.class);
    }

    public RoleProvider roleStorageManager() {
        if (this.roleStorageManager == null) {
            this.roleStorageManager = new RoleStorageManager(this, this.factory.getRoleStorageProviderTimeout());
        }
        return this.roleStorageManager;
    }

    public GroupProvider groupStorageManager() {
        if (this.groupStorageManager == null) {
            this.groupStorageManager = new GroupStorageManager(this);
        }
        return this.groupStorageManager;
    }

    public UserProvider userStorageManager() {
        if (this.userStorageManager == null) {
            this.userStorageManager = new UserStorageManager(this);
        }
        return this.userStorageManager;
    }

    public UserProvider users() {
        UserCache cache = this.getProvider(UserCache.class);
        if (cache != null) {
            return cache;
        }
        return this.userStorageManager();
    }

    public UserCredentialManager userCredentialManager() {
        if (this.userCredentialStorageManager == null) {
            this.userCredentialStorageManager = new UserCredentialStoreManager(this);
        }
        return this.userCredentialStorageManager;
    }

    public <T extends Provider> T getProvider(Class<T> clazz) {
        ProviderFactory<T> providerFactory;
        Integer hash = clazz.hashCode();
        Provider provider = this.providers.get(hash);
        if (provider == null && (providerFactory = this.factory.getProviderFactory(clazz)) != null) {
            provider = providerFactory.create((KeycloakSession)this);
            this.providers.put(hash, provider);
        }
        return (T)provider;
    }

    public <T extends Provider> T getProvider(Class<T> clazz, String id) {
        ProviderFactory<T> providerFactory;
        Integer hash = clazz.hashCode() + id.hashCode();
        Provider provider = this.providers.get(hash);
        if (provider == null && (providerFactory = this.factory.getProviderFactory(clazz, id)) != null) {
            provider = providerFactory.create((KeycloakSession)this);
            this.providers.put(hash, provider);
        }
        return (T)provider;
    }

    public <T extends Provider> T getComponentProvider(Class<T> clazz, String componentId) {
        RealmModel realm = this.getContext().getRealm();
        if (realm == null) {
            throw new IllegalArgumentException("Realm not set in the context.");
        }
        return this.getComponentProvider(clazz, componentId, KeycloakModelUtils.componentModelGetter((String)realm.getId(), (String)componentId));
    }

    public <T extends Provider> T getComponentProvider(Class<T> clazz, String componentId, Function<KeycloakSessionFactory, ComponentModel> modelGetter) {
        String realmId;
        ProviderFactory<T> providerFactory;
        Integer hash = clazz.hashCode() + componentId.hashCode();
        Provider provider = this.providers.get(hash);
        RealmModel realm = this.getContext().getRealm();
        if (provider == null && (providerFactory = this.factory.getProviderFactory(clazz, realmId = realm == null ? null : realm.getId(), componentId, modelGetter)) != null) {
            provider = providerFactory.create((KeycloakSession)this);
            this.providers.put(hash, provider);
        }
        return (T)provider;
    }

    public <T extends Provider> T getProvider(Class<T> clazz, ComponentModel componentModel) {
        String modelId = componentModel.getId();
        Object found = this.getAttribute(modelId);
        if (found != null) {
            return (T)((Provider)clazz.cast(found));
        }
        ProviderFactory<T> providerFactory = this.factory.getProviderFactory(clazz, componentModel.getProviderId());
        if (providerFactory == null) {
            return null;
        }
        ComponentFactory componentFactory = (ComponentFactory)providerFactory;
        Provider provider = (Provider)componentFactory.create((KeycloakSession)this, componentModel);
        this.enlistForClose(provider);
        this.setAttribute(modelId, provider);
        return (T)provider;
    }

    public <T extends Provider> Set<String> listProviderIds(Class<T> clazz) {
        return this.factory.getAllProviderIds(clazz);
    }

    public <T extends Provider> Set<T> getAllProviders(Class<T> clazz) {
        return this.listProviderIds(clazz).stream().map(id -> this.getProvider(clazz, (String)id)).collect(Collectors.toSet());
    }

    public Class<? extends Provider> getProviderClass(String providerClassName) {
        return this.factory.getProviderClass(providerClassName);
    }

    public RealmProvider realms() {
        if (this.model == null) {
            this.model = this.getRealmProvider();
        }
        return this.model;
    }

    public ClientProvider clients() {
        if (this.clientProvider == null) {
            this.clientProvider = this.getClientProvider();
        }
        return this.clientProvider;
    }

    public ClientScopeProvider clientScopes() {
        if (this.clientScopeProvider == null) {
            this.clientScopeProvider = this.getClientScopeProvider();
        }
        return this.clientScopeProvider;
    }

    public GroupProvider groups() {
        if (this.groupProvider == null) {
            this.groupProvider = this.getGroupProvider();
        }
        return this.groupProvider;
    }

    public RoleProvider roles() {
        if (this.roleProvider == null) {
            this.roleProvider = this.getRoleProvider();
        }
        return this.roleProvider;
    }

    public UserSessionProvider sessions() {
        if (this.sessionProvider == null) {
            this.sessionProvider = this.getProvider(UserSessionProvider.class);
        }
        return this.sessionProvider;
    }

    public UserLoginFailureProvider loginFailures() {
        if (this.userLoginFailureProvider == null) {
            this.userLoginFailureProvider = this.getProvider(UserLoginFailureProvider.class);
        }
        return this.userLoginFailureProvider;
    }

    public AuthenticationSessionProvider authenticationSessions() {
        if (this.authenticationSessionProvider == null) {
            this.authenticationSessionProvider = this.getProvider(AuthenticationSessionProvider.class);
        }
        return this.authenticationSessionProvider;
    }

    public KeyManager keys() {
        if (this.keyManager == null) {
            this.keyManager = new DefaultKeyManager(this);
        }
        return this.keyManager;
    }

    public ThemeManager theme() {
        if (this.themeManager == null) {
            this.themeManager = this.factory.getThemeManagerFactory().create(this);
        }
        return this.themeManager;
    }

    public TokenManager tokens() {
        if (this.tokenManager == null) {
            this.tokenManager = new DefaultTokenManager(this);
        }
        return this.tokenManager;
    }

    public VaultTranscriber vault() {
        if (this.vaultTranscriber == null) {
            this.vaultTranscriber = new DefaultVaultTranscriber(this.getProvider(VaultProvider.class));
        }
        return this.vaultTranscriber;
    }

    public ClientPolicyManager clientPolicy() {
        if (this.clientPolicyManager == null) {
            this.clientPolicyManager = this.getProvider(ClientPolicyManager.class);
        }
        return this.clientPolicyManager;
    }

    public void close() {
        Consumer<Provider> safeClose = p -> {
            try {
                p.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        this.providers.values().forEach(safeClose);
        this.closable.forEach(safeClose);
        for (Map.Entry<InvalidationHandler.InvalidableObjectType, Set<Object>> me : this.invalidationMap.entrySet()) {
            this.factory.invalidate(me.getKey(), me.getValue().toArray());
        }
    }
}

