/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.headers.SecurityHeadersProvider;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.utils.StringUtil;

public class FrontChannelLogoutHandler {
    private final KeycloakSession session;
    private final String sid;
    private final String issuer;
    private final List<ClientInfo> clients = new ArrayList<ClientInfo>();
    private String logoutRedirectUri;

    public static FrontChannelLogoutHandler current(KeycloakSession session) {
        return (FrontChannelLogoutHandler)session.getAttribute(FrontChannelLogoutHandler.class.getName());
    }

    public static FrontChannelLogoutHandler currentOrCreate(KeycloakSession session, AuthenticatedClientSessionModel clientSession) {
        FrontChannelLogoutHandler current = FrontChannelLogoutHandler.current(session);
        if (current == null) {
            return new FrontChannelLogoutHandler(session, clientSession);
        }
        return current;
    }

    private FrontChannelLogoutHandler(KeycloakSession session, AuthenticatedClientSessionModel clientSession) {
        this.session = session;
        this.sid = clientSession.getUserSession().getId();
        this.issuer = clientSession.getNote("iss");
        this.session.setAttribute(this.getClass().getName(), (Object)this);
    }

    public void addClient(ClientModel client) {
        this.clients.add(new ClientInfo(client));
    }

    public List<ClientInfo> getClients() {
        return this.clients;
    }

    public String getLogoutRedirectUri() {
        return this.logoutRedirectUri;
    }

    public Response renderLogoutPage(String redirectUri) {
        this.configureCSP();
        this.logoutRedirectUri = redirectUri;
        return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).createFrontChannelLogoutPage();
    }

    private void configureCSP() {
        StringBuilder allowFrameSrc = new StringBuilder();
        for (ClientInfo client : this.clients) {
            allowFrameSrc.append(client.frontChannelLogoutUrl.getAuthority()).append(' ');
        }
        ((SecurityHeadersProvider)this.session.getProvider(SecurityHeadersProvider.class)).options().allowAnyFrameAncestor();
        ((SecurityHeadersProvider)this.session.getProvider(SecurityHeadersProvider.class)).options().allowFrameSrc(allowFrameSrc.toString());
    }

    private URI createFrontChannelLogoutUrl(ClientModel client) {
        String frontChannelLogoutUrl = OIDCAdvancedConfigWrapper.fromClientModel(client).getFrontChannelLogoutUrl();
        if (StringUtil.isBlank((String)frontChannelLogoutUrl)) {
            frontChannelLogoutUrl = client.getBaseUrl();
        }
        if (frontChannelLogoutUrl == null) {
            throw new RuntimeException("Client [" + client.getClientId() + "] does not have a valid frontend logout URL");
        }
        UriBuilder builder = UriBuilder.fromUri((String)frontChannelLogoutUrl);
        builder.queryParam("sid", new Object[]{this.sid});
        builder.queryParam("iss", new Object[]{this.issuer});
        return builder.build(new Object[0]);
    }

    public class ClientInfo {
        private final ClientModel client;
        private final URI frontChannelLogoutUrl;

        public ClientInfo(ClientModel client) {
            this.client = client;
            this.frontChannelLogoutUrl = FrontChannelLogoutHandler.this.createFrontChannelLogoutUrl(client);
        }

        public String getFrontChannelLogoutUrl() {
            return this.frontChannelLogoutUrl.toString();
        }

        public String getName() {
            String name = this.client.getName();
            if (name == null) {
                return this.client.getClientId();
            }
            return name;
        }
    }
}

