/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.authentication.CredentialRegistrator;
import org.keycloak.authentication.DisplayTypeRequiredActionFactory;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.requiredactions.ConsoleUpdateTotp;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.OTPCredentialProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.OTPCredentialModel;
import org.keycloak.models.utils.CredentialValidation;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.validation.Validation;
import org.keycloak.utils.CredentialHelper;

public class UpdateTotp
implements RequiredActionProvider,
RequiredActionFactory,
DisplayTypeRequiredActionFactory,
CredentialRegistrator {
    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge = context.form().setAttribute("mode", context.getUriInfo().getQueryParameters().getFirst((Object)"mode")).createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        Stream otpCredentials;
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String challengeResponse = (String)formData.getFirst((Object)"totp");
        String totpSecret = (String)formData.getFirst((Object)"totpSecret");
        String mode = (String)formData.getFirst((Object)"mode");
        String userLabel = (String)formData.getFirst((Object)"userLabel");
        if (formData.containsKey((Object)"continue")) {
            LoginFormsProvider challenge = context.form();
            this.challengeToTotpAttributes(context, totpSecret, mode);
            context.challenge(challenge.createForm("login-config-totp-otp.ftl"));
            return;
        }
        EventBuilder event = context.getEvent();
        event.event(EventType.UPDATE_TOTP);
        OTPPolicy policy = context.getRealm().getOTPPolicy();
        OTPCredentialModel credentialModel = OTPCredentialModel.createFromPolicy((RealmModel)context.getRealm(), (String)totpSecret, (String)userLabel);
        if (Validation.isBlank(challengeResponse)) {
            LoginFormsProvider challenge = context.form().setAttribute("mode", (Object)mode).addError(new FormMessage("totp", "missingTotpMessage"));
            this.challengeToTotpAttributes(context, totpSecret, mode);
            context.challenge(challenge.createForm("login-config-totp-otp.ftl"));
            return;
        }
        if (!this.validateOTPCredential(context, challengeResponse, credentialModel, policy)) {
            LoginFormsProvider challenge = context.form().setAttribute("mode", (Object)mode).addError(new FormMessage("totp", "invalidTotpMessage"));
            this.challengeToTotpAttributes(context, totpSecret, mode);
            context.challenge(challenge.createForm("login-config-totp-otp.ftl"));
            return;
        }
        OTPCredentialProvider otpCredentialProvider = (OTPCredentialProvider)context.getSession().getProvider(CredentialProvider.class, "keycloak-otp");
        Stream stream = otpCredentials = otpCredentialProvider.isConfiguredFor(context.getRealm(), context.getUser()) ? context.getSession().userCredentialManager().getStoredCredentialsByTypeStream(context.getRealm(), context.getUser(), "otp") : Stream.empty();
        if (otpCredentials.count() >= 1L && Validation.isBlank(userLabel)) {
            LoginFormsProvider challenge = context.form().setAttribute("mode", (Object)mode).addError(new FormMessage("userLabel", "missingTotpDeviceNameMessage"));
            this.challengeToTotpAttributes(context, totpSecret, mode);
            context.challenge(challenge.createForm("login-config-totp-otp.ftl"));
            return;
        }
        if (!CredentialHelper.createOTPCredential((KeycloakSession)context.getSession(), (RealmModel)context.getRealm(), (UserModel)context.getUser(), (String)challengeResponse, (OTPCredentialModel)credentialModel)) {
            LoginFormsProvider challenge = context.form().setAttribute("mode", (Object)mode).addError(new FormMessage("totp", "invalidTotpMessage"));
            this.challengeToTotpAttributes(context, totpSecret, mode);
            context.challenge(challenge.createForm("login-config-totp-otp.ftl"));
            return;
        }
        context.getAuthenticationSession().setAuthNote("verified", "true");
        context.success();
    }

    private void challengeToTotpAttributes(RequiredActionContext context, String totpSecret, String mode) {
        LoginFormsProvider challenge = context.form();
        challenge.setAttribute("totpSecret", (Object)totpSecret);
        challenge.setAttribute("otpCredentials", (Object)context.getSession().userCredentialManager().isConfiguredFor(context.getRealm(), context.getUser(), context.getRealm().getOTPPolicy().getType()));
        if (mode != null) {
            challenge.setAttribute("mode", (Object)mode);
        }
    }

    protected boolean validateOTPCredential(RequiredActionContext context, String token, OTPCredentialModel credentialModel, OTPPolicy policy) {
        return CredentialValidation.validOTP((String)token, (OTPCredentialModel)credentialModel, (int)policy.getLookAheadWindow());
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public RequiredActionProvider createDisplay(KeycloakSession session, String displayType) {
        if (displayType == null) {
            return this;
        }
        if (!"console".equalsIgnoreCase(displayType)) {
            return null;
        }
        return ConsoleUpdateTotp.SINGLETON;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Configure OTP";
    }

    public String getId() {
        return UserModel.RequiredAction.CONFIGURE_TOTP.name();
    }

    public boolean isOneTimeAction() {
        return true;
    }
}

