/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import java.util.Iterator;
import java.util.Stack;
import picocli.CommandLine;

public final class PropertyMapperParameterConsumer
implements CommandLine.IParameterConsumer {
    static final CommandLine.IParameterConsumer INSTANCE = new PropertyMapperParameterConsumer();

    private PropertyMapperParameterConsumer() {
    }

    public void consumeParameters(Stack<String> args, CommandLine.Model.ArgSpec argSpec, CommandLine.Model.CommandSpec commandSpec) {
        if (argSpec instanceof CommandLine.Model.OptionSpec) {
            this.validateOption(args, argSpec, commandSpec);
        }
    }

    private void validateOption(Stack<String> args, CommandLine.Model.ArgSpec argSpec, CommandLine.Model.CommandSpec commandSpec) {
        CommandLine.Model.OptionSpec option = (CommandLine.Model.OptionSpec)argSpec;
        String name = String.join((CharSequence)", ", option.names());
        CommandLine commandLine = commandSpec.commandLine();
        if (args.isEmpty() || !this.isOptionValue(args.peek())) {
            throw new CommandLine.ParameterException(commandLine, "Missing required value for option '" + name + "' (" + argSpec.paramLabel() + ")." + this.getExpectedValuesMessage(argSpec, option));
        }
        String value = args.pop();
        if (!args.isEmpty() && this.isOptionValue(args.peek())) {
            throw new CommandLine.ParameterException(commandLine, "Option '" + name + "' expects a single value (" + argSpec.paramLabel() + ")" + this.getExpectedValuesMessage(argSpec, option));
        }
        if (this.isExpectedValue(option, value)) {
            return;
        }
        throw new CommandLine.ParameterException(commandLine, "Invalid value for option '" + name + "': " + value + "." + this.getExpectedValuesMessage(argSpec, option));
    }

    private boolean isOptionValue(String arg) {
        return !arg.startsWith("--") && !arg.startsWith("-");
    }

    private String getExpectedValuesMessage(CommandLine.Model.ArgSpec argSpec, CommandLine.Model.OptionSpec option) {
        return option.completionCandidates().iterator().hasNext() ? " Expected values are: " + String.join((CharSequence)", ", argSpec.completionCandidates()) : "";
    }

    private boolean isExpectedValue(CommandLine.Model.OptionSpec option, String value) {
        Iterator expectedValues = option.completionCandidates().iterator();
        if (!expectedValues.hasNext()) {
            return true;
        }
        while (expectedValues.hasNext()) {
            String expectedValue = (String)expectedValues.next();
            if (!expectedValue.equals(value)) continue;
            return true;
        }
        return false;
    }
}

