/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import io.quarkus.runtime.Quarkus;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.common.utils.StringUtil;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.keycloak.common.Profile;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.DefaultFactory;
import org.keycloak.quarkus.runtime.cli.ExecutionExceptionHandler;
import org.keycloak.quarkus.runtime.cli.Help;
import org.keycloak.quarkus.runtime.cli.HelpFactory;
import org.keycloak.quarkus.runtime.cli.PropertyMapperParameterConsumer;
import org.keycloak.quarkus.runtime.cli.SubCommandListRenderer;
import org.keycloak.quarkus.runtime.cli.command.Main;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;
import org.keycloak.quarkus.runtime.configuration.mappers.ConfigCategory;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import picocli.CommandLine;

public final class Picocli {
    public static final String ARG_PREFIX = "--";
    private static final String ARG_KEY_VALUE_SEPARATOR = "=";
    public static final String ARG_SHORT_PREFIX = "-";
    public static final String ARG_PART_SEPARATOR = "-";
    public static final String NO_PARAM_LABEL = "none";

    private Picocli() {
    }

    public static void parseAndRun(List<String> cliArgs) {
        CommandLine cmd = Picocli.createCommandLine(cliArgs);
        if (Boolean.getBoolean("kc.config.rebuild-and-exit")) {
            Picocli.runReAugmentationIfNeeded(cliArgs, cmd);
            Quarkus.asyncExit((int)cmd.getCommandSpec().exitCodeOnSuccess());
            return;
        }
        cmd.execute(cliArgs.toArray(new String[0]));
    }

    private static void runReAugmentationIfNeeded(List<String> cliArgs, CommandLine cmd) {
        if (Picocli.hasAutoBuildOption(cliArgs) && !Picocli.isHelpCommand(cliArgs)) {
            String profile;
            if (cliArgs.contains("start-dev") && (profile = Environment.getProfile()) == null) {
                Environment.forceDevProfile();
            }
            if (Picocli.requiresReAugmentation(cmd)) {
                Picocli.runReAugmentation(cliArgs, cmd);
            }
        }
    }

    private static boolean isHelpCommand(List<String> cliArgs) {
        return cliArgs.contains("--help") || cliArgs.contains("-h") || cliArgs.contains("--help-all");
    }

    public static boolean hasAutoBuildOption(List<String> cliArgs) {
        return cliArgs.contains("--auto-build") || cliArgs.contains("-b");
    }

    public static boolean requiresReAugmentation(CommandLine cmd) {
        if (Picocli.hasConfigChanges()) {
            Predicate<String> profileOptionMatcher = "--profile"::equals;
            if (ConfigArgsConfigSource.hasOptionValue(profileOptionMatcher = profileOptionMatcher.or("-pf"::equals), "dev") && !ConfigArgsConfigSource.getAllCliArgs().contains("start-dev")) {
                return false;
            }
            if (!Environment.isDevMode() && cmd != null) {
                cmd.getOut().println("Changes detected in configuration. Updating the server image.");
                List<String> cliInput = Picocli.getSanitizedCliInput();
                cmd.getOut().printf("For an optional runtime and bypass this step, please run the '%s' command prior to starting the server:%n%n\t%s %s %s%n%n", "build", Environment.getCommand(), "build", String.join((CharSequence)" ", cliInput) + "\n");
            }
            return true;
        }
        return Picocli.hasProviderChanges();
    }

    private static List<String> getSanitizedCliInput() {
        final ArrayList<String> properties = new ArrayList<String>();
        ConfigArgsConfigSource.parseConfigArgs(new BiConsumer<String, String>(){

            @Override
            public void accept(String key, String value) {
                properties.add(key + Picocli.ARG_KEY_VALUE_SEPARATOR + PropertyMappers.formatValue(key, value));
            }
        });
        return properties;
    }

    private static void runReAugmentation(List<String> cliArgs, CommandLine cmd) {
        ArrayList<String> configArgsList = new ArrayList<String>(cliArgs);
        configArgsList.remove("--auto-build");
        configArgsList.remove("-b");
        configArgsList.replaceAll(new UnaryOperator<String>(){

            @Override
            public String apply(String arg) {
                if (arg.equals("start") || arg.equals("start-dev")) {
                    return "build";
                }
                return arg;
            }
        });
        cmd.execute(configArgsList.toArray(new String[0]));
        if (!Environment.isDevMode()) {
            cmd.getOut().printf("Next time you run the server, just run:%n%n\t%s %s%n%n", Environment.getCommand(), "start");
        }
    }

    private static boolean hasProviderChanges() {
        Map persistedProps = PersistedConfigSource.getInstance().getProperties();
        Map<String, File> deployedProviders = Environment.getProviderFiles();
        if (persistedProps.isEmpty()) {
            return !deployedProviders.isEmpty();
        }
        Set providerKeys = persistedProps.keySet().stream().filter(Picocli::isProviderKey).collect(Collectors.toSet());
        if (deployedProviders.size() != providerKeys.size()) {
            return true;
        }
        for (String key : providerKeys) {
            String fileName = key.substring("kc.provider.file".length() + 1, key.lastIndexOf(46));
            if (!deployedProviders.containsKey(fileName)) {
                return true;
            }
            File file = deployedProviders.get(fileName);
            String lastModified = (String)persistedProps.get(key);
            if (lastModified.equals(String.valueOf(file.lastModified()))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasConfigChanges() {
        Optional<String> currentProfile = Optional.ofNullable(Environment.getProfile());
        Optional<String> persistedProfile = Configuration.getBuildTimeProperty("kc.profile");
        if (!persistedProfile.orElse("").equals(currentProfile.orElse(""))) {
            return true;
        }
        for (String propertyName : Configuration.getConfig().getPropertyNames()) {
            ConfigValue configValue;
            if (!PropertyMappers.isBuildTimeProperty(propertyName) || (configValue = Configuration.getConfig().getConfigValue(propertyName)) == null || configValue.getConfigSourceName() == null) continue;
            if (propertyName.startsWith("%")) {
                propertyName = propertyName.substring(propertyName.indexOf(46) + 1);
            }
            String persistedValue = Configuration.getBuildTimeProperty(propertyName).orElse("");
            String runtimeValue = Configuration.getRuntimeProperty(propertyName).orElse(null);
            if (runtimeValue == null && org.keycloak.utils.StringUtil.isNotBlank((String)persistedValue)) {
                return true;
            }
            if (persistedValue.equals(runtimeValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean isProviderKey(String key) {
        return key.startsWith("kc.provider.file");
    }

    public static CommandLine createCommandLine(List<String> cliArgs) {
        CommandLine.Model.CommandSpec spec = CommandLine.Model.CommandSpec.forAnnotatedObject((Object)new Main(), (CommandLine.IFactory)new DefaultFactory()).name(Environment.getCommand());
        for (CommandLine subCommand : spec.subcommands().values()) {
            CommandLine.Model.CommandSpec subCommandSpec = subCommand.getCommandSpec();
            subCommandSpec.addOption(((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String[])Help.OPTION_NAMES).usageHelp(true).description(new String[]{"This help message."})).build());
        }
        Picocli.addOption(spec, "start", Picocli.hasAutoBuildOption(cliArgs));
        Picocli.addOption(spec, "start-dev", true);
        Picocli.addOption(spec, "build", true);
        CommandLine cmd = new CommandLine((Object)spec);
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new ExecutionExceptionHandler());
        cmd.setHelpFactory((CommandLine.IHelpFactory)new HelpFactory());
        cmd.getHelpSectionMap().put("commandList", new SubCommandListRenderer());
        cmd.setErr(new PrintWriter(System.err, true));
        return cmd;
    }

    private static void addOption(CommandLine.Model.CommandSpec spec, String command, boolean includeBuildTime) {
        CommandLine.Model.CommandSpec commandSpec = ((CommandLine)spec.subcommands().get(command)).getCommandSpec();
        ArrayList<PropertyMapper> mappers = new ArrayList<PropertyMapper>(PropertyMappers.getRuntimeMappers());
        if (includeBuildTime) {
            mappers.addAll(PropertyMappers.getBuildTimeMappers());
            Picocli.addFeatureOptions(commandSpec);
        }
        Picocli.addMappedOptionsToArgGroups(commandSpec, mappers);
    }

    private static void addFeatureOptions(CommandLine.Model.CommandSpec commandSpec) {
        CommandLine.Model.ArgGroupSpec.Builder featureGroupBuilder = CommandLine.Model.ArgGroupSpec.builder().heading(ConfigCategory.FEATURE.getHeading()).order(ConfigCategory.FEATURE.getOrder()).validate(false);
        String previewName = Profile.Type.PREVIEW.name().toLowerCase();
        featureGroupBuilder.addArg((CommandLine.Model.ArgSpec)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String[])new String[]{"-ft", "--features"}).description(new String[]{"Enables all tech preview features."})).paramLabel(previewName)).completionCandidates(Collections.singleton(previewName))).parameterConsumer(PropertyMapperParameterConsumer.INSTANCE)).type(String.class)).build());
        List<String> expectedValues = Arrays.asList("enabled", "disabled");
        for (Profile.Feature feature : Profile.Feature.values()) {
            featureGroupBuilder.addArg((CommandLine.Model.ArgSpec)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)("--features-" + feature.name().toLowerCase()), (String[])new String[0]).description(new String[]{"Enables the " + feature.name() + " feature."})).paramLabel(String.join((CharSequence)"|", expectedValues))).type(String.class)).parameterConsumer(PropertyMapperParameterConsumer.INSTANCE)).completionCandidates(expectedValues)).build());
        }
        commandSpec.addArgGroup(featureGroupBuilder.build());
    }

    private static void addMappedOptionsToArgGroups(CommandLine.Model.CommandSpec cSpec, List<PropertyMapper> propertyMappers) {
        for (ConfigCategory category : ConfigCategory.values()) {
            List mappersInCategory = propertyMappers.stream().filter(m -> category.equals((Object)m.getCategory())).collect(Collectors.toList());
            if (mappersInCategory.isEmpty()) continue;
            CommandLine.Model.ArgGroupSpec.Builder argGroupBuilder = CommandLine.Model.ArgGroupSpec.builder().heading(category.getHeading()).order(category.getOrder()).validate(false);
            for (PropertyMapper mapper : mappersInCategory) {
                String name = ARG_PREFIX + PropertyMappers.toCLIFormat(mapper.getFrom()).substring(3);
                String description = mapper.getDescription();
                if (description == null || cSpec.optionsMap().containsKey(name) || name.endsWith("-")) continue;
                String defaultValue = mapper.getDefaultValue();
                Iterable<String> expectedValues = mapper.getExpectedValues();
                argGroupBuilder.addArg((CommandLine.Model.ArgSpec)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)name, (String[])new String[0]).defaultValue(defaultValue)).description(new String[]{description})).paramLabel(mapper.getParamLabel())).completionCandidates(expectedValues)).parameterConsumer(PropertyMapperParameterConsumer.INSTANCE)).type(String.class)).hidden(mapper.isHidden())).build());
            }
            cSpec.addArgGroup(argGroupBuilder.build());
        }
    }

    public static void println(CommandLine cmd, String message) {
        cmd.getOut().println(message);
    }

    public static String normalizeKey(String key) {
        return StringUtil.replaceNonAlphanumericByUnderscores((String)key).replace('_', '.');
    }

    public static List<String> parseArgs(String[] rawArgs) {
        if (rawArgs.length == 0) {
            return List.of();
        }
        ConfigArgsConfigSource.setCliArgs(rawArgs);
        ArrayList<String> args = new ArrayList<String>(List.of(rawArgs));
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            String next;
            String arg = (String)iterator.next();
            if (!arg.startsWith("--spi")) continue;
            iterator.remove();
            if (arg.contains(ARG_KEY_VALUE_SEPARATOR) || (next = (String)iterator.next()).startsWith(ARG_PREFIX)) continue;
            iterator.remove();
        }
        return args;
    }
}

