/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.utils;

import io.quarkus.bootstrap.util.ZipUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.keycloak.common.Version;
import org.keycloak.it.utils.KeycloakDistribution;

public final class RawKeycloakDistribution
implements KeycloakDistribution {
    private Process keycloak;
    private int exitCode = -1;
    private final Path distPath;
    private final List<String> outputStream = new ArrayList<String>();
    private final List<String> errorStream = new ArrayList<String>();
    private boolean manualStop;
    private String relativePath;
    private int httpPort;
    private boolean debug;
    private boolean reCreate;
    private ExecutorService outputExecutor;

    public RawKeycloakDistribution(boolean debug, boolean manualStop, boolean reCreate) {
        this.debug = debug;
        this.manualStop = manualStop;
        this.reCreate = reCreate;
        this.distPath = this.prepareDistribution();
    }

    @Override
    public void start(List<String> arguments) {
        this.reset();
        if (this.manualStop && this.isRunning()) {
            throw new IllegalStateException("Server already running. You should manually stop the server before starting it again.");
        }
        this.stop();
        try {
            this.startServer(arguments);
            if (this.manualStop) {
                this.asyncReadOutput();
                this.waitForReadiness();
            } else {
                this.readOutput();
            }
        }
        catch (Exception cause) {
            this.stop();
            throw new RuntimeException("Failed to start the server", cause);
        }
        finally {
            if (!this.manualStop) {
                this.stop();
            }
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            try {
                this.keycloak.destroy();
                this.keycloak.waitFor(10L, TimeUnit.SECONDS);
                this.exitCode = this.keycloak.exitValue();
            }
            catch (Exception cause) {
                this.keycloak.destroyForcibly();
                throw new RuntimeException("Failed to stop the server", cause);
            }
        }
        this.shutdownOutputExecutor();
    }

    @Override
    public List<String> getOutputStream() {
        return this.outputStream;
    }

    @Override
    public List<String> getErrorStream() {
        return this.errorStream;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isManualStop() {
        return this.manualStop;
    }

    @Override
    public String[] getCliArgs(List<String> arguments) {
        this.relativePath = arguments.stream().filter(arg -> arg.startsWith("--http-relative-path")).map(arg -> arg.substring(arg.indexOf(61) + 1)).findAny().orElse("/");
        this.httpPort = Integer.parseInt(arguments.stream().filter(arg -> arg.startsWith("--http-port")).map(arg -> arg.substring(arg.indexOf(61) + 1)).findAny().orElse("8080"));
        return KeycloakDistribution.super.getCliArgs(arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForReadiness() throws MalformedURLException {
        URL contextRoot = new URL("http://localhost:" + this.httpPort + ("/" + this.relativePath + "/realms/master/").replace("//", "/"));
        HttpURLConnection connection = null;
        long startTime = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() - startTime > this.getStartTimeout()) {
                throw new IllegalStateException("Timeout [" + this.getStartTimeout() + "] while waiting for Quarkus server");
            }
            try {
                Thread.sleep(1000L);
                if ("https".equals(contextRoot.getProtocol())) {
                    connection = (HttpURLConnection)contextRoot.openConnection();
                    HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                    httpsConnection.setSSLSocketFactory(this.createInsecureSslSocketFactory());
                    httpsConnection.setHostnameVerifier(this.createInsecureHostnameVerifier());
                } else {
                    connection = (HttpURLConnection)contextRoot.openConnection();
                }
                connection.setReadTimeout((int)this.getStartTimeout());
                connection.setConnectTimeout((int)this.getStartTimeout());
                connection.connect();
                if (connection.getResponseCode() != 200) continue;
                break;
            }
            catch (Exception exception) {}
            continue;
            finally {
                if (connection == null) continue;
                connection.disconnect();
                continue;
            }
            break;
        }
    }

    private long getStartTimeout() {
        return TimeUnit.SECONDS.toMillis(120L);
    }

    private HostnameVerifier createInsecureHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        };
    }

    private SSLSocketFactory createInsecureSslSocketFactory() throws IOException {
        SSLSocketFactory socketFactory;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            socketFactory = sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IOException("Can't create unsecure trust manager");
        }
        return socketFactory;
    }

    private boolean isRunning() {
        return this.keycloak != null && this.keycloak.isAlive();
    }

    private void asyncReadOutput() {
        this.shutdownOutputExecutor();
        this.outputExecutor = Executors.newSingleThreadExecutor();
        this.outputExecutor.execute(this::readOutput);
    }

    private void shutdownOutputExecutor() {
        if (this.outputExecutor != null) {
            this.outputExecutor.shutdown();
            try {
                this.outputExecutor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException cause) {
                throw new RuntimeException("Failed to terminate output executor", cause);
            }
            finally {
                this.outputExecutor = null;
            }
        }
    }

    private void reset() {
        this.outputStream.clear();
        this.errorStream.clear();
        this.exitCode = -1;
        this.keycloak = null;
        this.shutdownOutputExecutor();
    }

    private Path prepareDistribution() {
        try {
            Path distRootPath = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("kc-tests");
            distRootPath.toFile().mkdirs();
            File distFile = new File("../../../distribution/server-x-dist/target/keycloak.x-" + Version.VERSION_KEYCLOAK + ".zip");
            if (!distFile.exists()) {
                throw new RuntimeException("Distribution archive " + distFile.getAbsolutePath() + " doesn't exists");
            }
            distRootPath.toFile().mkdirs();
            String distDirName = distFile.getName().replace("keycloak-server-x-dist", "keycloak.x");
            Path distPath = distRootPath.resolve(distDirName.substring(0, distDirName.lastIndexOf(46)));
            if (this.reCreate || !distPath.toFile().exists()) {
                distPath.toFile().delete();
                ZipUtils.unzip((Path)distFile.toPath(), (Path)distRootPath);
            }
            if (!distPath.resolve("bin").resolve("kc.sh").toFile().setExecutable(true)) {
                throw new RuntimeException("Cannot set kc.sh executable");
            }
            return distPath;
        }
        catch (Exception cause) {
            throw new RuntimeException("Failed to prepare distribution", cause);
        }
    }

    private void readOutput() {
        try (BufferedReader outStream = new BufferedReader(new InputStreamReader(this.keycloak.getInputStream()));
             BufferedReader errStream = new BufferedReader(new InputStreamReader(this.keycloak.getErrorStream()));){
            while (this.keycloak.isAlive()) {
                this.readStream(outStream, this.outputStream);
                this.readStream(errStream, this.errorStream);
            }
        }
        catch (Throwable cause) {
            throw new RuntimeException("Failed to read server output", cause);
        }
    }

    private void readStream(BufferedReader reader, List<String> stream) throws IOException {
        String line;
        while (reader.ready() && (line = reader.readLine()) != null) {
            stream.add(line);
            System.out.println(line);
        }
    }

    private void startServer(List<String> arguments) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(this.getCliArgs(arguments));
        ProcessBuilder builder = pb.directory(this.distPath.resolve("bin").toFile());
        builder.environment().put("KEYCLOAK_ADMIN", "admin");
        builder.environment().put("KEYCLOAK_ADMIN_PASSWORD", "admin");
        FileUtils.deleteDirectory((File)this.distPath.resolve("data").toFile());
        this.keycloak = builder.start();
    }
}

