/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.utils.RoleUtils;

public abstract class AbstractClientModel<E extends AbstractEntity>
implements ClientModel {
    protected final KeycloakSession session;
    protected final RealmModel realm;
    protected final E entity;

    public AbstractClientModel(KeycloakSession session, RealmModel realm, E entity) {
        Objects.requireNonNull(entity, "entity");
        Objects.requireNonNull(realm, "realm");
        this.session = session;
        this.realm = realm;
        this.entity = entity;
    }

    public void addClientScopes(Set<ClientScopeModel> clientScopes, boolean defaultScope) {
        this.session.clients().addClientScopes(this.getRealm(), (ClientModel)this, clientScopes, defaultScope);
    }

    public void addClientScope(ClientScopeModel clientScope, boolean defaultScope) {
        this.addClientScopes(Collections.singleton(clientScope), defaultScope);
    }

    public void removeClientScope(ClientScopeModel clientScope) {
        this.session.clients().removeClientScope(this.getRealm(), (ClientModel)this, clientScope);
    }

    public Map<String, ClientScopeModel> getClientScopes(boolean defaultScope) {
        return this.session.clients().getClientScopes(this.getRealm(), (ClientModel)this, defaultScope);
    }

    public Stream<RoleModel> getRealmScopeMappingsStream() {
        return this.getScopeMappingsStream().filter(r -> RoleUtils.isRealmRole((RoleModel)r, (RealmModel)this.realm));
    }

    public RoleModel getRole(String name) {
        return this.session.roles().getClientRole((ClientModel)this, name);
    }

    public RoleModel addRole(String name) {
        return this.session.roles().addClientRole((ClientModel)this, name);
    }

    public RoleModel addRole(String id, String name) {
        return this.session.roles().addClientRole((ClientModel)this, id, name);
    }

    public boolean removeRole(RoleModel role) {
        return this.session.roles().removeRole(role);
    }

    public Stream<RoleModel> getRolesStream() {
        return this.session.roles().getClientRolesStream((ClientModel)this, null, null);
    }

    public Stream<RoleModel> getRolesStream(Integer firstResult, Integer maxResults) {
        return this.session.roles().getClientRolesStream((ClientModel)this, firstResult, maxResults);
    }

    public Stream<RoleModel> searchForRolesStream(String search, Integer first, Integer max) {
        return this.session.roles().searchForClientRolesStream((ClientModel)this, search, first, max);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientModel)) {
            return false;
        }
        ClientModel that = (ClientModel)o;
        return Objects.equals(that.getId(), this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

