/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import java.util.Objects;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MapAuthenticationFlowEntity
extends UpdatableEntity.Impl {
    private String id;
    private String alias;
    private String description;
    private String providerId;
    private Boolean builtIn = false;
    private Boolean topLevel = false;

    private MapAuthenticationFlowEntity() {
    }

    public static MapAuthenticationFlowEntity fromModel(AuthenticationFlowModel model) {
        if (model == null) {
            return null;
        }
        MapAuthenticationFlowEntity entity = new MapAuthenticationFlowEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAlias(model.getAlias());
        entity.setBuiltIn(model.isBuiltIn());
        entity.setDescription(model.getDescription());
        entity.setProviderId(model.getProviderId());
        entity.setTopLevel(model.isTopLevel());
        return entity;
    }

    public static AuthenticationFlowModel toModel(MapAuthenticationFlowEntity entity) {
        if (entity == null) {
            return null;
        }
        AuthenticationFlowModel model = new AuthenticationFlowModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        model.setBuiltIn(entity.isBuiltIn().booleanValue());
        model.setDescription(entity.getDescription());
        model.setProviderId(entity.getProviderId());
        model.setTopLevel(entity.isTopLevel().booleanValue());
        return model;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.updated = !Objects.equals(this.id, id);
        this.id = id;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.updated = !Objects.equals(this.alias, alias);
        this.alias = alias;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.updated = !Objects.equals(this.description, description);
        this.description = description;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.updated = !Objects.equals(this.providerId, providerId);
        this.providerId = providerId;
    }

    public Boolean isBuiltIn() {
        return this.builtIn;
    }

    public void setBuiltIn(boolean builtIn) {
        this.updated = !Objects.equals(this.builtIn, builtIn);
        this.builtIn = builtIn;
    }

    public Boolean isTopLevel() {
        return this.topLevel;
    }

    public void setTopLevel(boolean topLevel) {
        this.updated = !Objects.equals(this.topLevel, topLevel);
        this.topLevel = topLevel;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapAuthenticationFlowEntity)) {
            return false;
        }
        MapAuthenticationFlowEntity other = (MapAuthenticationFlowEntity)obj;
        return Objects.equals(other.getId(), this.getId());
    }
}

