/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.client;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.dblock.DBLockManager;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntityImpl;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.client.JpaClientMapStorageProvider;
import org.keycloak.models.map.storage.jpa.client.entity.JpaClientEntity;
import org.keycloak.models.map.storage.jpa.updater.MapJpaUpdaterProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class JpaClientMapStorageProviderFactory
implements AmphibianProviderFactory<MapStorageProvider>,
MapStorageProviderFactory,
EnvironmentDependentProviderFactory {
    static final DeepCloner CLONER = new DeepCloner.Builder().constructor(JpaClientEntity.class, JpaClientEntity::new).constructor(MapProtocolMapperEntity.class, MapProtocolMapperEntityImpl::new).build();
    public static final String PROVIDER_ID = "jpa-client-map-storage";
    private volatile EntityManagerFactory emf;
    private static final Logger logger = Logger.getLogger(JpaClientMapStorageProviderFactory.class);
    private Config.Scope config;

    public MapStorageProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new JpaClientMapStorageProvider(this.emf.createEntityManager());
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "JPA Client Map Storage";
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    public void close() {
        if (this.emf != null) {
            this.emf.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.emf == null) {
            JpaClientMapStorageProviderFactory jpaClientMapStorageProviderFactory = this;
            synchronized (jpaClientMapStorageProviderFactory) {
                if (this.emf == null) {
                    logger.debugf("Initializing JPA connections%s", StackUtil.getShortStackTrace());
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    String unitName = "keycloak-client-store";
                    String dataSource = this.config.get("dataSource");
                    if (dataSource != null) {
                        properties.put("javax.persistence.nonJtaDataSource", dataSource);
                    } else {
                        String password;
                        properties.put("javax.persistence.jdbc.url", this.config.get("url"));
                        properties.put("javax.persistence.jdbc.driver", this.config.get("driver"));
                        String user = this.config.get("user");
                        if (user != null) {
                            properties.put("javax.persistence.jdbc.user", user);
                        }
                        if ((password = this.config.get("password")) != null) {
                            properties.put("javax.persistence.jdbc.password", password);
                        }
                    }
                    String schema = this.config.get("schema");
                    if (schema != null) {
                        properties.put("hibernate.default_schema", schema);
                    }
                    properties.put("hibernate.show_sql", this.config.getBoolean("showSql", Boolean.valueOf(false)));
                    properties.put("hibernate.format_sql", this.config.getBoolean("formatSql", Boolean.valueOf(true)));
                    properties.put("hibernate.dialect", this.config.get("driverDialect"));
                    Integer isolation = this.config.getInt("isolation");
                    if (isolation != null) {
                        if (isolation < 4) {
                            logger.warn((Object)"Concurrent requests may not be reliable with transaction level lower than TRANSACTION_REPEATABLE_READ.");
                        }
                        properties.put("hibernate.connection.isolation", String.valueOf(isolation));
                    } else {
                        logger.warn((Object)"Concurrent requests may not be reliable with transaction level lower than TRANSACTION_REPEATABLE_READ.");
                    }
                    Connection connection = this.getConnection();
                    try {
                        this.printOperationalInfo(connection);
                        this.customChanges(connection, schema, session, (MapJpaUpdaterProvider)session.getProvider(MapJpaUpdaterProvider.class));
                        logger.trace((Object)"Creating EntityManagerFactory");
                        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
                        if (properties.containsKey("hibernate.classLoaders")) {
                            classLoaders.addAll((Collection)properties.get("hibernate.classLoaders"));
                        }
                        classLoaders.add(this.getClass().getClassLoader());
                        properties.put("hibernate.classLoaders", classLoaders);
                        this.emf = JpaUtils.createEntityManagerFactory((KeycloakSession)session, (String)unitName, properties, (boolean)false);
                        logger.trace((Object)"EntityManagerFactory created");
                    }
                    finally {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException e) {
                                logger.warn((Object)"Can't close connection", (Throwable)e);
                            }
                        }
                    }
                }
            }
        }
    }

    private void customChanges(Connection connection, String schema, KeycloakSession session, MapJpaUpdaterProvider updater) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), lockSession -> {
            DBLockManager dbLockManager = new DBLockManager(lockSession);
            DBLockProvider dbLock2 = dbLockManager.getDBLock();
            dbLock2.waitForLock(DBLockProvider.Namespace.DATABASE);
            try {
                updater.update(ClientModel.class, connection, schema);
            }
            finally {
                dbLock2.releaseLock();
            }
        });
    }

    private void printOperationalInfo(Connection connection) {
        try {
            LinkedHashMap<String, String> operationalInfo = new LinkedHashMap<String, String>();
            DatabaseMetaData md = connection.getMetaData();
            operationalInfo.put("databaseUrl", md.getURL());
            operationalInfo.put("databaseUser", md.getUserName());
            operationalInfo.put("databaseProduct", md.getDatabaseProductName() + " " + md.getDatabaseProductVersion());
            operationalInfo.put("databaseDriver", md.getDriverName() + " " + md.getDriverVersion());
            logger.infof("Database info: %s", (Object)operationalInfo.toString());
        }
        catch (SQLException e) {
            logger.warn((Object)("Unable to prepare operational info due database exception: " + e.getMessage()));
        }
    }

    private Connection getConnection() {
        try {
            String dataSourceLookup = this.config.get("dataSource");
            if (dataSourceLookup != null) {
                DataSource dataSource = (DataSource)new InitialContext().lookup(dataSourceLookup);
                return dataSource.getConnection();
            }
            Class.forName(this.config.get("driver"));
            return DriverManager.getConnection(StringPropertyReplacer.replaceProperties((String)this.config.get("url"), (Properties)System.getProperties()), this.config.get("user"), this.config.get("password"));
        }
        catch (ClassNotFoundException | SQLException | NamingException e) {
            throw new RuntimeException("Failed to connect to database", e);
        }
    }
}

