/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.group;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.group.MapGroupEntity;
import org.keycloak.models.map.storage.hotRod.client.HotRodAttributeEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;
import org.keycloak.models.map.storage.hotRod.group.HotRodGroupEntity;

public class HotRodGroupEntityDelegate
extends HotRodGroupEntity.AbstractHotRodGroupEntityDelegate
implements MapGroupEntity,
HotRodEntityDelegate<HotRodGroupEntity> {
    private final HotRodGroupEntity hotRodEntity;
    private final DeepCloner cloner;

    public HotRodGroupEntityDelegate() {
        this(DeepCloner.DUMB_CLONER);
    }

    public HotRodGroupEntityDelegate(DeepCloner cloner) {
        this.cloner = cloner;
        this.hotRodEntity = new HotRodGroupEntity();
    }

    public HotRodGroupEntityDelegate(HotRodGroupEntity hotRodEntity) {
        this.hotRodEntity = hotRodEntity;
        this.cloner = DeepCloner.DUMB_CLONER;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodGroupEntityDelegate)) {
            return false;
        }
        HotRodGroupEntityDelegate other = (HotRodGroupEntityDelegate)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getGrantedRoles(), other.getGrantedRoles()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getParentId(), other.getParentId()) && Objects.equals(this.getRealmId(), other.getRealmId());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodGroupEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodGroupEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodGroupEntity e1 = (HotRodGroupEntity)o1;
        HotRodGroupEntity e2 = (HotRodGroupEntity)o2;
        return Objects.equals(e1.entityVersion, e2.entityVersion) && Objects.equals(e1.id, e2.id) && Objects.equals(e1.realmId, e2.realmId) && Objects.equals(e1.name, e2.name) && Objects.equals(e1.parentId, e2.parentId) && Objects.equals(e1.attributes, e2.attributes) && Objects.equals(e1.grantedRoles, e2.grantedRoles);
    }

    public static int entityHashCode(HotRodGroupEntity e) {
        return e.id == null ? Objects.hash(e) : e.id.hashCode();
    }

    public <V> V deepClone(V obj) {
        return (V)this.cloner.from(obj);
    }

    public void setAttribute(String p0, List<String> p1) {
        if (this.hotRodEntity.attributes == null) {
            this.hotRodEntity.attributes = new HashSet<HotRodAttributeEntity>();
        }
        boolean valueUndefined = p1 == null || p1.isEmpty();
        p1 = p1 == null ? null : new LinkedList<String>(p1);
        this.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey);
        this.updated |= !valueUndefined && this.hotRodEntity.attributes.add(new HotRodAttributeEntity(p0, p1));
    }

    public void setAttributes(Map<String, List<String>> p0) {
        p0 = p0 == null ? null : (Map)p0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : new LinkedList((Collection)entry.getValue()), (o1, o2) -> o1, HashMap::new));
        Set<HotRodAttributeEntity> migrated = HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodAttributeEntityFromMapEntry);
        this.updated |= !Objects.equals(this.hotRodEntity.attributes, migrated);
        this.hotRodEntity.attributes = migrated;
    }

    public void removeAttribute(String p0) {
        this.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey);
    }

    public Map<String, List<String>> getAttributes() {
        return HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.attributes, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public List<String> getAttribute(String p0) {
        return HotRodTypesUtils.getMapValueFromSet(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setGrantedRoles(Set<String> p0) {
        HashSet<String> migrated = p0 = p0 == null ? null : new HashSet<String>(p0);
        this.updated |= !Objects.equals(this.hotRodEntity.grantedRoles, migrated);
        this.hotRodEntity.grantedRoles = migrated;
    }

    public Set<String> getGrantedRoles() {
        return this.hotRodEntity.grantedRoles;
    }

    public void addGrantedRole(String p0) {
        if (this.hotRodEntity.grantedRoles == null) {
            this.hotRodEntity.grantedRoles = new HashSet<String>();
        }
        String migrated = p0;
        this.updated |= this.hotRodEntity.grantedRoles.add(migrated);
    }

    public void removeGrantedRole(String p0) {
        if (this.hotRodEntity.grantedRoles == null) {
            return;
        }
        boolean removed = this.hotRodEntity.grantedRoles.remove(p0);
        this.updated |= removed;
    }

    public void setName(String p0) {
        String migrated = p0;
        this.updated |= !Objects.equals(this.hotRodEntity.name, migrated);
        this.hotRodEntity.name = migrated;
    }

    public String getName() {
        return this.hotRodEntity.name;
    }

    public String getParentId() {
        return this.hotRodEntity.parentId;
    }

    public void setParentId(String p0) {
        String migrated = p0;
        this.updated |= !Objects.equals(this.hotRodEntity.parentId, migrated);
        this.hotRodEntity.parentId = migrated;
    }

    public void setRealmId(String p0) {
        String migrated = p0;
        this.updated |= !Objects.equals(this.hotRodEntity.realmId, migrated);
        this.hotRodEntity.realmId = migrated;
    }

    public String getRealmId() {
        return this.hotRodEntity.realmId;
    }

    @Override
    public HotRodGroupEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

