/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.InsertStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate13_0_0_MigrateDefaultRoles
extends CustomKeycloakTask {
    private final Map<String, String> realmIdsAndNames = new HashMap<String, String>();

    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        this.extractRealmIdsAndNames("SELECT ID,NAME FROM " + this.getTableName("REALM"));
        String clientTable = this.getTableName("CLIENT");
        String clientDefaultRolesTable = this.getTableName("CLIENT_DEFAULT_ROLES");
        String compositeRoleTable = this.getTableName("COMPOSITE_ROLE");
        for (Map.Entry<String, String> entry : this.realmIdsAndNames.entrySet()) {
            String id = UUID.randomUUID().toString();
            String roleName = this.determineDefaultRoleName(entry.getKey(), entry.getValue());
            this.statements.add(new InsertStatement(null, null, this.database.correctObjectName("KEYCLOAK_ROLE", Table.class)).addColumnValue("ID", (Object)id).addColumnValue("CLIENT_REALM_CONSTRAINT", (Object)entry.getKey()).addColumnValue("CLIENT_ROLE", (Object)Boolean.FALSE).addColumnValue("DESCRIPTION", (Object)("${role_" + roleName + "}")).addColumnValue("NAME", (Object)roleName).addColumnValue("REALM_ID", (Object)entry.getKey()).addColumnValue("REALM", (Object)entry.getKey()));
            this.statements.add(new UpdateStatement(null, null, this.database.correctObjectName("REALM", Table.class)).addNewColumnValue("DEFAULT_ROLE", (Object)id).setWhereClause("REALM.ID=?").addWhereParameter((Object)entry.getKey()));
            this.statements.add(new RawSqlStatement("INSERT INTO " + compositeRoleTable + " (COMPOSITE, CHILD_ROLE) SELECT '" + id + "', ROLE_ID FROM " + this.getTableName("REALM_DEFAULT_ROLES") + " WHERE REALM_ID = '" + this.database.escapeStringForDatabase(entry.getKey()) + "'"));
            this.statements.add(new RawSqlStatement("INSERT INTO " + compositeRoleTable + " (COMPOSITE, CHILD_ROLE) SELECT '" + id + "', " + clientDefaultRolesTable + ".ROLE_ID FROM " + clientDefaultRolesTable + " INNER JOIN " + clientTable + " ON " + clientTable + ".ID = " + clientDefaultRolesTable + ".CLIENT_ID AND " + clientTable + ".REALM_ID = '" + this.database.escapeStringForDatabase(entry.getKey()) + "'"));
        }
    }

    private void extractRealmIdsAndNames(String sql) throws CustomChangeException {
        try (PreparedStatement statement = this.jdbcConnection.prepareStatement(sql);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                this.realmIdsAndNames.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when extracting data from previous version", (Throwable)e);
        }
    }

    private String determineDefaultRoleName(String realmId, String realmName) throws CustomChangeException {
        String roleName = "default-roles-" + realmName.toLowerCase();
        if (this.isRoleNameAvailable(realmId, roleName)) {
            return roleName;
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            roleName = "default-roles-" + realmName.toLowerCase() + "-" + i;
            if (!this.isRoleNameAvailable(realmId, roleName)) continue;
            return roleName;
        }
        throw new CustomChangeException(this.getTaskId() + ": Exception when extracting data from previous version. Unable to determine default role name.");
    }

    /*
     * Exception decompiling
     */
    private boolean isRoleNameAvailable(String realmId, String roleName) throws CustomChangeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected String getTaskId() {
        return "Migrate Default roles (13.0.0)";
    }
}

