/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.jpa.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.keycloak.storage.jpa.KeyUtils;

@NamedQueries(value={@NamedQuery(name="findBrokerLinkByUser", query="select link from BrokerLinkEntity link where link.userId = :userId"), @NamedQuery(name="findBrokerLinkByUserAndProvider", query="select link from BrokerLinkEntity link where link.userId = :userId and link.identityProvider = :identityProvider and link.realmId = :realmId"), @NamedQuery(name="findUserByBrokerLinkAndRealm", query="select link.userId from BrokerLinkEntity link where link.realmId = :realmId and link.identityProvider = :identityProvider and link.brokerUserId = :brokerUserId"), @NamedQuery(name="deleteBrokerLinkByStorageProvider", query="delete from BrokerLinkEntity social where social.storageProviderId = :storageProviderId"), @NamedQuery(name="deleteBrokerLinkByRealm", query="delete from BrokerLinkEntity social where social.realmId = :realmId"), @NamedQuery(name="deleteBrokerLinkByIdentityProvider", query="delete from BrokerLinkEntity b where b.realmId = :realmId and b.identityProvider = :providerAlias"), @NamedQuery(name="deleteBrokerLinkByRealmAndLink", query="delete from BrokerLinkEntity social where social.userId IN (select u.id from UserEntity u where realmId=:realmId and u.federationLink=:link)"), @NamedQuery(name="deleteBrokerLinkByUser", query="delete from BrokerLinkEntity social where social.userId = :userId and social.realmId = :realmId")})
@Table(name="BROKER_LINK")
@Entity
@IdClass(value=Key.class)
public class BrokerLinkEntity {
    @Id
    @Column(name="USER_ID")
    private String userId;
    @Id
    @Column(name="IDENTITY_PROVIDER")
    protected String identityProvider;
    @Column(name="REALM_ID")
    protected String realmId;
    @Column(name="STORAGE_PROVIDER_ID")
    protected String storageProviderId;
    @Column(name="BROKER_USER_ID")
    protected String brokerUserId;
    @Column(name="BROKER_USERNAME")
    protected String brokerUserName;
    @Column(name="TOKEN")
    protected String token;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        KeyUtils.assertValidKey(userId);
        this.userId = userId;
    }

    public String getIdentityProvider() {
        return this.identityProvider;
    }

    public void setIdentityProvider(String identityProvider) {
        this.identityProvider = identityProvider;
    }

    public String getBrokerUserId() {
        return this.brokerUserId;
    }

    public void setBrokerUserId(String brokerUserId) {
        this.brokerUserId = brokerUserId;
    }

    public String getBrokerUserName() {
        return this.brokerUserName;
    }

    public void setBrokerUserName(String brokerUserName) {
        this.brokerUserName = brokerUserName;
    }

    public String getStorageProviderId() {
        return this.storageProviderId;
    }

    public void setStorageProviderId(String storageProviderId) {
        this.storageProviderId = storageProviderId;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof BrokerLinkEntity)) {
            return false;
        }
        BrokerLinkEntity key = (BrokerLinkEntity)o;
        if (this.identityProvider != null ? !this.identityProvider.equals(key.identityProvider) : key.identityProvider != null) {
            return false;
        }
        return !(this.userId != null ? !this.userId.equals(key.userId != null ? key.userId : null) : key.userId != null);
    }

    public int hashCode() {
        int result = this.userId != null ? this.userId.hashCode() : 0;
        result = 31 * result + (this.identityProvider != null ? this.identityProvider.hashCode() : 0);
        return result;
    }

    public static class Key
    implements Serializable {
        protected String userId;
        protected String identityProvider;

        public Key() {
        }

        public Key(String userId, String identityProvider) {
            this.userId = userId;
            this.identityProvider = identityProvider;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getIdentityProvider() {
            return this.identityProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.identityProvider != null ? !this.identityProvider.equals(key.identityProvider) : key.identityProvider != null) {
                return false;
            }
            return !(this.userId != null ? !this.userId.equals(key.userId != null ? key.userId : null) : key.userId != null);
        }

        public int hashCode() {
            int result = this.userId != null ? this.userId.hashCode() : 0;
            result = 31 * result + (this.identityProvider != null ? this.identityProvider.hashCode() : 0);
            return result;
        }
    }
}

