/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import javax.persistence.EntityManager;
import org.keycloak.Config;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RealmProviderFactory;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.JpaRealmProvider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public class JpaRealmProviderFactory
implements RealmProviderFactory,
ProviderEventListener {
    private Runnable onClose;
    public static final String PROVIDER_ID = "jpa";
    public static final int PROVIDER_PRIORITY = 1;

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register((ProviderEventListener)this);
        this.onClose = () -> factory.unregister((ProviderEventListener)this);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public JpaRealmProvider create(KeycloakSession session) {
        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        return new JpaRealmProvider(session, em, null);
    }

    public void close() {
        this.onClose.run();
    }

    public void onEvent(ProviderEvent event) {
        if (event instanceof RoleContainerModel.RoleRemovedEvent) {
            RealmModel realm;
            RoleContainerModel.RoleRemovedEvent e = (RoleContainerModel.RoleRemovedEvent)event;
            RoleModel role = e.getRole();
            RoleContainerModel container = role.getContainer();
            if (container instanceof RealmModel) {
                realm = (RealmModel)container;
            } else if (container instanceof ClientModel) {
                realm = ((ClientModel)container).getRealm();
            } else {
                return;
            }
            ((JpaRealmProvider)e.getKeycloakSession().getProvider(RealmProvider.class)).preRemove(realm, role);
        }
    }

    public int order() {
        return 1;
    }
}

