/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.dballocator.client.retry;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.dballocator.client.BackoffRetryPolicy;
import org.keycloak.testsuite.dballocator.client.exceptions.DBAllocatorUnavailableException;

public class IncrementalBackoffRetryPolicy
implements BackoffRetryPolicy {
    public static final int DEFAULT_TOTAL_RETRIES = 3;
    public static final int DEFAULT_BACKOFF_TIME = 10;
    public static final TimeUnit DEFAULT_BACKOFF_TIME_UNIT = TimeUnit.SECONDS;
    private final int totalRetries;
    private final int backoffTime;
    private final TimeUnit backoffTimeUnit;
    private final Logger logger = Logger.getLogger(IncrementalBackoffRetryPolicy.class);

    public IncrementalBackoffRetryPolicy() {
        this(3, 10, DEFAULT_BACKOFF_TIME_UNIT);
    }

    public IncrementalBackoffRetryPolicy(int totalRetries, int backoffTime, TimeUnit backoffTimeUnit) {
        this.backoffTime = backoffTime;
        this.backoffTimeUnit = backoffTimeUnit;
        this.totalRetries = totalRetries;
    }

    @Override
    public Response retryTillHttpOk(Callable<Response> callableSupplier) throws DBAllocatorUnavailableException {
        return this.retryTillHttpOk(callableSupplier, this.totalRetries, this.backoffTime, this.backoffTimeUnit);
    }

    private Response retryTillHttpOk(Callable<Response> callableSupplier, int totalRetries, int backoffTime, TimeUnit backoffTimeUnit) throws DBAllocatorUnavailableException {
        int retryCount = 0;
        while (true) {
            Response response;
            try {
                response = callableSupplier.call();
            }
            catch (Exception e) {
                response = null;
            }
            if (response != null) {
                this.logger.info((Object)("Response status: " + response.getStatus()));
                if (response.getStatus() == 200) {
                    return response;
                }
            }
            this.logger.info((Object)("retryCount: " + (retryCount + 1) + ", totalRetries: " + totalRetries));
            if (++retryCount > totalRetries) {
                this.logger.info((Object)("retryCount exceeded: " + retryCount));
                throw new DBAllocatorUnavailableException(response);
            }
            this.logger.info((Object)("backoffTime * retryCount: " + backoffTime * retryCount));
            LockSupport.parkNanos(backoffTimeUnit.toNanos(backoffTime * retryCount));
        }
    }
}

