/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.dballocator.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.keycloak.testsuite.dballocator.client.BackoffRetryPolicy;
import org.keycloak.testsuite.dballocator.client.data.AllocationResult;
import org.keycloak.testsuite.dballocator.client.data.EraseResult;
import org.keycloak.testsuite.dballocator.client.data.ReleaseResult;
import org.keycloak.testsuite.dballocator.client.exceptions.DBAllocatorException;
import org.keycloak.testsuite.dballocator.client.retry.IncrementalBackoffRetryPolicy;

public class DBAllocatorServiceClient {
    private static final int TIMEOUT = 10000;
    private final Client restClient;
    private final URI allocatorServletURI;
    private final BackoffRetryPolicy retryPolicy;
    private final Logger logger = Logger.getLogger(DBAllocatorServiceClient.class);

    public DBAllocatorServiceClient(String allocatorServletURI, BackoffRetryPolicy retryPolicy) {
        Objects.requireNonNull(allocatorServletURI, "DB Allocator URI must not be null");
        this.allocatorServletURI = URI.create(allocatorServletURI);
        this.retryPolicy = retryPolicy != null ? retryPolicy : new IncrementalBackoffRetryPolicy();
        this.restClient = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)this.createEngine()).build();
    }

    private final ApacheHttpClient43Engine createEngine() {
        RequestConfig reqConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).setConnectionRequestTimeout(10000).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(reqConfig).setMaxConnTotal(1).build();
        ApacheHttpClient43Engine engine = new ApacheHttpClient43Engine((HttpClient)httpClient);
        engine.setFollowRedirects(true);
        return engine;
    }

    public AllocationResult allocate(String user, String type, int expiration, TimeUnit expirationTimeUnit, String location) throws DBAllocatorException {
        Objects.requireNonNull(user, "User can not be null");
        Objects.requireNonNull(type, "DB Type must not be null");
        try {
            String typeWithLocation = location != null ? type + "&&" + location : type;
            Invocation.Builder target = this.restClient.target(this.allocatorServletURI).queryParam("operation", new Object[]{"allocate"}).queryParam("requestee", new Object[]{user}).queryParam("expression", new Object[]{typeWithLocation}).queryParam("expiry", new Object[]{expirationTimeUnit.toMinutes(expiration)}).request();
            this.logger.info((Object)("Calling " + this.allocatorServletURI));
            Response response = this.retryPolicy.retryTillHttpOk(() -> target.get());
            Properties properties = new Properties();
            String content = (String)response.readEntity(String.class);
            if (content != null) {
                try (ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());){
                    properties.load(is);
                }
            }
            return AllocationResult.successful(properties);
        }
        catch (IOException e) {
            throw new DBAllocatorException(e);
        }
    }

    public EraseResult erase(AllocationResult allocationResult) throws DBAllocatorException {
        Objects.requireNonNull(allocationResult, "Previous allocation result must not be null");
        Objects.requireNonNull(allocationResult.getUUID(), "UUID must not be null");
        Invocation.Builder target = this.restClient.target(this.allocatorServletURI).queryParam("operation", new Object[]{"erase"}).queryParam("uuid", new Object[]{allocationResult.getUUID()}).request();
        try (Response response = this.retryPolicy.retryTillHttpOk(() -> target.get());){
            EraseResult eraseResult = EraseResult.successful(allocationResult.getUUID());
            return eraseResult;
        }
    }

    public ReleaseResult release(AllocationResult allocationResult) throws DBAllocatorException {
        Objects.requireNonNull(allocationResult, "Previous allocation result must not be null");
        Objects.requireNonNull(allocationResult.getUUID(), "UUID must not be null");
        Invocation.Builder target = this.restClient.target(this.allocatorServletURI).queryParam("operation", new Object[]{"dealloc"}).queryParam("uuid", new Object[]{allocationResult.getUUID()}).request();
        try (Response response = this.retryPolicy.retryTillHttpOk(() -> target.get());){
            ReleaseResult releaseResult = ReleaseResult.successful(allocationResult.getUUID());
            return releaseResult;
        }
    }
}

