/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.dballocator;

import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.keycloak.testsuite.dballocator.client.DBAllocatorServiceClient;
import org.keycloak.testsuite.dballocator.client.data.AllocationResult;
import org.keycloak.testsuite.dballocator.client.data.ReleaseResult;
import org.keycloak.testsuite.dballocator.client.exceptions.DBAllocatorException;
import org.keycloak.testsuite.dballocator.client.retry.IncrementalBackoffRetryPolicy;

@Mojo(name="release", defaultPhase=LifecyclePhase.TEST)
public class ReleaseDBMojo
extends AbstractMojo {
    private final Log logger = this.getLog();
    @Parameter(defaultValue="${project}", required=true)
    protected MavenProject project;
    @Parameter(property="dballocator.summary", defaultValue="true")
    private boolean printSummary;
    @Parameter(property="dballocator.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="dballocator.retry.totalRetries", defaultValue="3")
    private int totalRetries;
    @Parameter(property="dballocator.retry.backoffSeconds", defaultValue="10")
    private int backoffTimeSeconds;
    @Parameter(property="dballocator.uri")
    private String dbAllocatorURI;
    @Parameter(property="dballocator.allocated.uuid")
    private String allocatedUUID;

    public void execute() throws MojoFailureException {
        if (this.skip) {
            this.logger.info((CharSequence)"Skipping");
            return;
        }
        this.logger.info((CharSequence)("Total retries: " + this.totalRetries + "; backOffTime: " + this.backoffTimeSeconds));
        try {
            IncrementalBackoffRetryPolicy retryPolicy = new IncrementalBackoffRetryPolicy(this.totalRetries, this.backoffTimeSeconds, TimeUnit.SECONDS);
            DBAllocatorServiceClient client = new DBAllocatorServiceClient(this.dbAllocatorURI, retryPolicy);
            ReleaseResult release = client.release(AllocationResult.forRelease(this.allocatedUUID));
            if (this.printSummary) {
                this.logger.info((CharSequence)"Released database:");
                this.logger.info((CharSequence)("-- UUID: " + release.getUUID()));
            }
        }
        catch (DBAllocatorException e) {
            String error = e.getMessage();
            if (e.getErrorResponse() != null) {
                error = String.format("[%s](%s)", e.getErrorResponse().getStatus(), e.getErrorResponse().readEntity(String.class));
            }
            throw new MojoFailureException("An error occurred while communicating with DBAllocator (" + error + ")", (Throwable)e);
        }
    }
}

