/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.dballocator.client.data;

import java.util.Properties;

public class AllocationResult {
    private final String uuid;
    private final String driver;
    private final String database;
    private final String user;
    private final String password;
    private final String url;

    private AllocationResult(String uuid) {
        this.uuid = uuid;
        this.driver = null;
        this.database = null;
        this.user = null;
        this.password = null;
        this.url = null;
    }

    private AllocationResult(String uuid, String driver, String database, String user, String password, String url) {
        this.uuid = uuid;
        this.driver = driver;
        this.database = database;
        this.user = user;
        this.password = password;
        this.url = url;
    }

    public static AllocationResult forRelease(String uuid) {
        return new AllocationResult(uuid);
    }

    public static AllocationResult successful(Properties properties) {
        return new AllocationResult(properties.getProperty("uuid"), properties.getProperty("db.jdbc_class"), properties.getProperty("db.name"), properties.getProperty("db.username"), properties.getProperty("db.password"), properties.getProperty("db.jdbc_url"));
    }

    public String getDriver() {
        return this.driver;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getURL() {
        return this.url;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String toString() {
        return "AllocationResult{uuid='" + this.uuid + '\'' + ", driver='" + this.driver + '\'' + ", database='" + this.database + '\'' + ", user='" + this.user + '\'' + ", password='" + this.password + '\'' + ", url='" + this.url + '\'' + '}';
    }
}

