/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.dballocator;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.keycloak.testsuite.dballocator.client.DBAllocatorServiceClient;
import org.keycloak.testsuite.dballocator.client.data.AllocationResult;
import org.keycloak.testsuite.dballocator.client.data.EraseResult;
import org.keycloak.testsuite.dballocator.client.exceptions.DBAllocatorException;
import org.keycloak.testsuite.dballocator.client.retry.IncrementalBackoffRetryPolicy;

@Mojo(name="allocate", defaultPhase=LifecyclePhase.PROCESS_TEST_RESOURCES)
public class AllocateDBMojo
extends AbstractMojo {
    private final Log logger = this.getLog();
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    List<MavenProject> reactorProjects;
    @Parameter(property="dballocator.summary", defaultValue="true")
    private boolean printSummary;
    @Parameter(property="dballocator.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="dballocator.retry.totalRetries", defaultValue="3")
    private int totalRetries;
    @Parameter(property="dballocator.retry.backoffSeconds", defaultValue="10")
    private int backoffTimeSeconds;
    @Parameter(property="dballocator.uri")
    private String dbAllocatorURI;
    @Parameter(property="dballocator.user")
    private String user;
    @Parameter(property="user.name")
    private String fallbackUser;
    @Parameter(property="dballocator.type")
    private String type;
    @Parameter(property="dballocator.expirationMin", defaultValue="1440")
    private int expirationInMinutes;
    @Parameter(property="dballocator.location", defaultValue="geo_RDU")
    private String location;
    @Parameter(property="dballocator.properties.driver", defaultValue="keycloak.connectionsJpa.driver")
    private String propertyDriver;
    @Parameter(property="dballocator.properties.database", defaultValue="keycloak.connectionsJpa.database")
    private String propertyDatabase;
    @Parameter(property="dballocator.properties.user", defaultValue="keycloak.connectionsJpa.user")
    private String propertyUser;
    @Parameter(property="dballocator.properties.password", defaultValue="keycloak.connectionsJpa.password")
    private String propertyPassword;
    @Parameter(property="dballocator.properties.url", defaultValue="keycloak.connectionsJpa.url")
    private String propertyURL;

    public void execute() throws MojoFailureException {
        if (this.skip) {
            this.logger.info((CharSequence)"Skipping");
            return;
        }
        this.logger.info((CharSequence)("Total retries: " + this.totalRetries + "; backOffTime: " + this.backoffTimeSeconds));
        try {
            IncrementalBackoffRetryPolicy retryPolicy = new IncrementalBackoffRetryPolicy(this.totalRetries, this.backoffTimeSeconds, TimeUnit.SECONDS);
            DBAllocatorServiceClient client = new DBAllocatorServiceClient(this.dbAllocatorURI, retryPolicy);
            this.setFallbackUserIfNecessary();
            AllocationResult allocate = client.allocate(this.user, this.type, this.expirationInMinutes, TimeUnit.MINUTES, this.location);
            this.reactorProjects.forEach(project -> this.setPropertiesToProject((MavenProject)project, allocate));
            if (this.printSummary) {
                this.logger.info((CharSequence)"Allocated database:");
                this.logger.info((CharSequence)("-- UUID: " + allocate.getUUID()));
                this.logger.info((CharSequence)("-- Driver: " + allocate.getDriver()));
                this.logger.info((CharSequence)("-- Database: " + allocate.getDatabase()));
                this.logger.info((CharSequence)("-- User: " + allocate.getUser()));
                this.logger.info((CharSequence)("-- Password: " + allocate.getPassword()));
                this.logger.info((CharSequence)("-- URL: " + allocate.getURL()));
            }
            EraseResult eraseResult = client.erase(allocate);
            if (this.printSummary) {
                this.logger.info((CharSequence)"Erased database:");
                this.logger.info((CharSequence)("-- UUID: " + eraseResult.getUUID()));
            }
        }
        catch (DBAllocatorException e) {
            String error = e.getMessage();
            if (e.getErrorResponse() != null) {
                error = String.format("[%s](%s)", e.getErrorResponse().getStatus(), e.getErrorResponse().readEntity(String.class));
            }
            throw new MojoFailureException("An error occurred while communicating with DBAllocator (" + error + ")", (Throwable)e);
        }
    }

    private void setFallbackUserIfNecessary() {
        if (StringUtils.isBlank((CharSequence)this.user)) {
            if (StringUtils.isBlank((CharSequence)this.fallbackUser)) {
                throw new IllegalArgumentException("Both dballocator.user and user.name are empty");
            }
            this.user = this.fallbackUser;
        }
    }

    private void setPropertiesToProject(MavenProject project, AllocationResult allocate) {
        project.getProperties().setProperty(this.propertyDriver, allocate.getDriver());
        project.getProperties().setProperty(this.propertyDatabase, allocate.getDatabase());
        project.getProperties().setProperty(this.propertyUser, allocate.getUser());
        project.getProperties().setProperty(this.propertyPassword, allocate.getPassword());
        project.getProperties().setProperty(this.propertyURL, allocate.getURL());
        project.getProperties().setProperty("dballocator.allocated.uuid", allocate.getUUID());
    }
}

